<?php

namespace App\Livewire\Exams;

use App\Models\Chapter;
use App\Models\ChapterExam;
use App\Models\ClassRoom;
use App\Models\Exam;
use App\Models\Material;
use Livewire\Component;
use Livewire\WithPagination;

class ExamComponent extends Component
{

    use WithPagination;

    public $name,$question_count, $classRoomId, $materialId, $chapterIds = [], $examId;
    public $isModalOpen = false;
    public $isDeleteConfirmationOpen = false;
    public $search = '';
    public $perPage = 10;
    public $sortField = 'name';
    public $exam_time;
    public $sortDirection = 'asc';

    public $max_questions=0;
    public $materials=[];
    public $chapters=[];

    public  function  onClassRoomChange()
    {

        $this->chapters=[];
        $this->materials=[];
        $this->materials = Material::query()->where('class_room_id', $this->classRoomId)->get();
    }
    public  function  onMaterialChange()
    {
        $this->chapters = Chapter::query()->where('material_id', $this->materialId)->get();
    }
    public function render()
    {

        $classRooms = ClassRoom::all();
        $exams = Exam::query()

            ->where('name', 'like', '%' . $this->search . '%')
            ->orderBy($this->sortField, $this->sortDirection)
            ->where('material_id',  'like',"%{$this->materialId}%")
            ->where('class_room_id',  'like',"%{$this->classRoomId}%")

            ->paginate($this->perPage);

        return view('livewire.exams.exam-component', compact('exams', 'classRooms'))->layout('layouts.admin.master');
    }

    public function sortBy($field)
    {
        $this->sortDirection = $this->sortField === $field
            ? ($this->sortDirection === 'asc' ? 'desc' : 'asc')
            : 'asc';

        $this->sortField = $field;
    }

    public function openModal($examId = null)
    {

//dd($examId);
        $this->examId = $examId;
        if ($examId) {
            $exam = Exam::with('chapters')->find($examId);
            $this->name = $exam->name;
            $this->question_count = $exam->question_count;
            $this->classRoomId = $exam->class_room_id;
            $this->materials=Material::query()->where('class_room_id',$this->classRoomId)->get();
            $this->materialId = $exam->material_id;
            $this->chapters = Chapter::query()->where('material_id',$this->materialId)->get(); // Fetch selected chapter IDs
            $this->exam_time=$exam->exam_time;
            $this->chapterIds = $exam->chapters()->pluck('chapter_id')->toArray(); // Fetch selected chapter IDs
        } else {
            $this->resetInputFields();
        }

        $this->isModalOpen = true;
    }

    public function closeModal()
    {
        $this->resetInputFields();
        $this->isModalOpen = false;
    }

    public function save()
    {
        $this->validate([
            'name' => 'required|string|max:255',
            'classRoomId' => 'required|exists:class_rooms,id',
            'question_count'=>'required|integer',
            'materialId' => 'required|exists:materials,id',
            'chapterIds' => 'required|array', // Validate as an array
            'chapterIds.*' => 'exists:chapters,id',
            'exam_time'=>'required|integer|min:1'// Validate each chapter ID
        ]);

//        dd($this->name);
        // Create or update the exam
        $exam = Exam::updateOrCreate(['id' => $this->examId], [
            'name' => $this->name,
            'class_room_id' => $this->classRoomId,
            'material_id' => $this->materialId,
            'question_count'=>$this->question_count,
            'exam_time'=>$this->exam_time,
        ]);

        // Sync the chapters with the exam (for many-to-many relationship)
        $exam->chapters()->sync($this->chapterIds);

        $this->closeModal();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
    }

    public function confirmDelete($examId)
    {
        $this->examId = $examId;
        $this->isDeleteConfirmationOpen = true;
    }




    public function deleteConfirmed()
    {
        Exam::findOrFail($this->examId)->delete();
        $this->closeDeleteConfirmation();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
    }
    public function closeDeleteConfirmation()
    {
        $this->isDeleteConfirmationOpen = false;
    }
    private function resetInputFields()
    {
        $this->name = '';
        $this->classRoomId = '';
        $this->materialId = '';
        $this->chapterIds = [];
        $this->chapters=[];
        $this->materials=[];
        $this->question_count='';
        $this->examId = null;
        $this->exam_time='';
    }

}
