<?php

namespace App\Livewire\Governorates;

use App\Models\Governorate;
use Livewire\Component;
use Livewire\WithPagination;

class GovernoratesComponent extends Component
{
    use WithPagination;
    public $isModalOpen = false;
    public $isDeleteConfirmationOpen = false;
    public $name, $status=1, $governorateId;
    public $search = '';
    public $sortField = 'name';
    public $sortDirection = 'asc';


    public $perPage = 10; // Pagination limit

    public function openModal($id = null)
    {
        $this->reset(['name', 'status', 'governorateId']);
        $this->isModalOpen = true;

        if ($id) {
            $governorate = Governorate::findOrFail($id);
            $this->fill($governorate->only('name', 'status')); // More concise

            $this->governorateId = $governorate->id;
        }
    }

    public function closeModal()
    {
        $this->isModalOpen = false;
    }

    public function save()
    {

        $this->validate([
            'name' => 'required|string|max:255',
        ]);
        Governorate::updateOrCreate(
            ['id' => $this->governorateId],
            [
                'name' => $this->name,
                'status' => $this->status ? 1 : 0,
            ]
        );

        $this->closeModal();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);

    }

    public function confirmDelete($id)
    {
        $this->governorateId = $id;
        $this->isDeleteConfirmationOpen = true;
    }

    public function closeDeleteConfirmation()
    {
        $this->isDeleteConfirmationOpen = false;
    }

    public function deleteConfirmed()
    {
        Governorate::findOrFail($this->governorateId)->delete();

        $this->closeDeleteConfirmation();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);

       // session()->flash('message', 'Governorate deleted successfully.');
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function sortBy($field)
    {
        $this->sortDirection = $this->sortField === $field ? ($this->sortDirection === 'asc' ? 'desc' : 'asc') : 'asc';
        $this->sortField = $field;
    }

    public function render()
    {
        $governorates = Governorate::query()
            ->where('name', 'like', "%{$this->search}%")
            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate($this->perPage);

        return view('livewire.governorates.governorates-component', [
            'governorates' => $governorates,
        ])->layout('layouts.admin.master');
    }
}
