<?php
namespace App\Livewire\Grades;

use App\Models\Grade;
use Livewire\Component;
use Livewire\WithPagination;

class GradesComponent extends Component
{
    use WithPagination;
    protected $listeners = ['localeChanged' => '$refresh'];

    public $isModalOpen = false;
    public $isDeleteConfirmationOpen = false;
    public $name = ['ar' => '', 'en' => ''], $note, $gradeId;
    public $search = '';
    public $sortField = 'name';
    public $sortDirection = 'asc';

    protected $rules = [
        'name.ar' => 'required|string|max:255',
        'name.en' => 'required|string|max:255',
        'note' => 'nullable|string',
    ];

    public function render()
    {
        $grades = Grade::query()
            ->where('name->ar', 'like', '%' . $this->search . '%')
            ->orWhere('name->en', 'like', '%' . $this->search . '%')
            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate(10);

        return view('livewire.admin.grades.grades-component', [
            'grades' => $grades,
        ])->layout('layouts.admin.master');
    }

    public function openModal($id = null)
    {
        $this->reset();
        $this->isModalOpen = true;

        if ($id) {
            $grade = Grade::find($id);
            $this->gradeId = $grade->id;
            $this->name = $grade->getTranslations('name'); // Get translations as an array
            $this->note = $grade->note;
        }
    }

    public function closeModal()
    {
        $this->isModalOpen = false;
    }

    public function save()
    {
        $this->validate();

        if ($this->gradeId) {
            $grade = Grade::find($this->gradeId);
            $grade->update([
                'name' => $this->name,
                'note' => $this->note,
            ]);
        } else {
            Grade::create([
                'name' => $this->name,
                'note' => $this->note,
            ]);
        }

        $this->closeModal();
        session()->flash('message', 'Grade saved successfully.');
    }

    public function confirmDelete($id)
    {
        $this->gradeId = $id;
        $this->isDeleteConfirmationOpen = true;
    }

    public function closeDeleteConfirmation()
    {
        $this->isDeleteConfirmationOpen = false;
    }

    public function deleteConfirmed()
    {
        if ($this->gradeId) {
            Grade::find($this->gradeId)->delete();
        }
        $this->closeDeleteConfirmation();
        session()->flash('message', 'Grade deleted successfully.');
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function sortBy($field)
    {
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection === 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortField = $field;
            $this->sortDirection = 'asc';
        }
    }
}
