<?php

namespace App\Livewire\Labs;

use App\Models\Lab;
use Livewire\Component;
use Livewire\WithPagination;

class LabComponent extends Component
{

    use WithPagination;
    public $isModalOpen = false;
    public $isDeleteConfirmationOpen = false;
    public $name, $status=1, $labId;
    public $search = '';
    public $sortField = 'name';
    public $sortDirection = 'asc';


    public $perPage = 10; // Pagination limit

    public function openModal($id = null)
    {
        $this->reset(['name', 'status', 'labId']);
        $this->isModalOpen = true;

        if ($id) {
            $lab = Lab::findOrFail($id);
            $this->fill($lab->only('name', 'status')); // More concise

            $this->labId = $lab->id;
        }
    }

    public function closeModal()
    {
        $this->isModalOpen = false;
    }

    public function save()
    {

        $this->validate([
            'name' => 'required|string|max:255',
        ]);
        Lab::updateOrCreate(
            ['id' => $this->labId],
            [
                'name' => $this->name,
                'status' => $this->status ? 1 : 0,
            ]
        );

        $this->closeModal();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);

    }

    public function confirmDelete($id)
    {
        $this->labId = $id;
        $this->isDeleteConfirmationOpen = true;
    }

    public function closeDeleteConfirmation()
    {
        $this->isDeleteConfirmationOpen = false;
    }

    public function deleteConfirmed()
    {
        Lab::findOrFail($this->labId)->delete();

        $this->closeDeleteConfirmation();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);

    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function sortBy($field)
    {
        $this->sortDirection = $this->sortField === $field ? ($this->sortDirection === 'asc' ? 'desc' : 'asc') : 'asc';
        $this->sortField = $field;
    }

    public function render()
    {
        $labs = Lab::query()
            ->where('name', 'like', "%{$this->search}%")
            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate($this->perPage);

        return view('livewire.labs.lab-compnent', [
            'labs' => $labs,
        ])->layout('layouts.admin.master');
    }

}
