<?php


namespace App\Livewire\Lessons;

use App\Imports\QuestionImport;
use App\Imports\StudentImport;
use App\Models\Answer;
use App\Models\Chapter;
use App\Models\ClassRoom;
use App\Models\Lesson;
use App\Models\Material;
use App\Models\Question;
use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\WithPagination;
use Maatwebsite\Excel\Facades\Excel;

class LessonComponent extends Component
{
    use WithFileUploads;
    use WithPagination;
    public $isModalOpen = false;
    public $edit_question_attachment;
    public $show_question_attachment;
    public  $isQuestionModalOpen = false;
    public $isDeleteConfirmationOpen = false;
    public $questions=[];
    public $name, $status = 1,$edit_question_id,$edit_answers=[], $lessonId, $question, $answers, $classRoomId, $materialId, $chapterId, $attachment, $cover_attachment,$showListQuestion=false;
    public $search = null;
    public $edit_answer;
    public  $edit_questions=null;
    public $sortField = 'name';
    public $sortDirection = 'asc';
    public $search_materials = [];
    public  $code;
    public $description;
    public $file;
    public $search_material_id=null;
    public $question_attachment;
    public  $isEditQuestionModalOpen=false;
    public $existingVideoPath = null;
    public $existingCoverPath = null;
    public $search_class_room_id='';
    public $search_chapter_id='';
    public $materials = [];

    public $search_chapters=[];

    public $chapters = [];

    public  $isDeleteQuestionConfirmationOpen=false;
    public $isExcelModalOpen = false;
    public  $vedioUrl;
    public $showVideoModal=false;
    public  function  onClassRoomChange()
    {
        $this->materials = Material::query()->where('class_room_id', $this->classRoomId)->get();
    }


    public function onClassRoomSerachChange(){
        $this->search_material_id='';
        $this->search_chapter_id='';
        $this->search_chapters = [];
        $this->search_materials = Material::where('class_room_id', $this->search_class_room_id)->get();

    }



    public function onMaterialSerachChange(){
        $this->search_chapter_id='';
        $this->search_chapters = Chapter::where('material_id', $this->search_material_id)->get();

    }

    // onMaterialSerachChange
    public function updatedSearchClassRoomId($value)
    {
        $this->fetchMaterials($value);
    }

    public function fetchMaterials($classRoomId)
    {
        $this->search_materials = Material::where('class_room_id', $classRoomId)->get();
    }

    public  function  onMaterialChange()
    {
        $this->chapters = Chapter::query()->where('material_id', $this->materialId)->get();
    }
    public function openModal($id = null)
    {
        $this->reset(['name', 'classRoomId', 'materialId', 'code',  'materials', 'chapterId', 'chapters', 'description', 'attachment', 'existingVideoPath','lessonId']); // Also reset materialId
        $this->isModalOpen = true;
        $this->classRoomId = $this->search_class_room_id;
        $this->materialId = $this->search_material_id;
        $this->chapterId = $this->search_chapter_id;
        $this->chapters = Chapter::query()->where('material_id', $this->search_material_id)->get();
        $this->materials = Material::query()->where('class_room_id', $this->search_class_room_id)->get();

        if ($id) {
            $lesson = Lesson::findOrFail($id);
            $classRoomId = $lesson->materials ? $lesson->materials->class_room_id : null;
            $this->chapterId = $lesson->chapter_id??$this->search_chapter_id;
            $this->name = $lesson->name;
            $this->classRoomId = $classRoomId??$this->search_class_room_id;
            $this->materialId = $lesson->material_id??$this->search_material_id;
            $this->code = $lesson->code;
            $this->description = $lesson->description;
            $this->existingVideoPath = $lesson->attachment; // Set the existing video path
            $this->attachment = $lesson->attachment; // Set the existing video path
            $this->materials = Material::query()->where('class_room_id', $this->classRoomId)->get();
            $this->chapters = Chapter::query()->where('material_id', $this->materialId)->get();
            $this->lessonId = $id;
        }
    }

    public function closeModal()
    {
        $this->isModalOpen = false;
    }

    public function save()
    {

        $this->validate([
            'name' => 'required|string|max:255',
            'code' => 'required|string|max:500',
//            'attachment' => 'required|max:255',
            'classRoomId' => 'required|exists:class_rooms,id',
            'materialId' => 'required|exists:materials,id',
            'chapterId' => 'required|exists:chapters,id',
        ]);





        Lesson::query()->updateOrCreate(
            [
                'chapter_id' => $this->chapterId,
                'id' => $this->lessonId,

            ],
            [
                'code' => $this->code,
                'name' => $this->name,
                'material_id' => $this->materialId,
                'description' => $this->description,
                'attachment' => $this->attachment ?? null,
                'cover_attachment' => $this->cover_attachment ?? null,

            ]
        );

        $this->closeModal();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
    }

    public function confirmDelete($id)
    {
        $this->lessonId = $id;
        //            dd($id);
        $this->isDeleteConfirmationOpen = true;
    }

    public function closeDeleteConfirmation()
    {
        $this->isDeleteConfirmationOpen = false;
    }

    public function deleteConfirmed()
    {
        Lesson::findOrFail($this->lessonId)->delete();

        $this->closeDeleteConfirmation();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function sortBy($field)
    {
        $this->sortDirection = $this->sortField === $field ? ($this->sortDirection === 'asc' ? 'desc' : 'asc') : 'asc';
        $this->sortField = $field;
    }



    // Remove chapter row by index

    public function openModalQuestion($id = null)
    {

        $this->reset(['question',   'answers']);
        $this->isQuestionModalOpen = true;

        if ($id) {
            $lesson = Lesson::findOrFail($id);
            $this->name = $lesson->name;
            $this->status = $lesson->status;
            $this->lessonId = $lesson->id;



            // Initialize with default chapter data if not already present
            if (empty($this->answers)) {
                $this->answers = [
                    [
                        'name' => '', // Default empty name
                        'lesson_id' => $this->lessonId,

                    ]
                ];
            }
        }
    }

    public function closeQuestionModal()
    {
        $this->isQuestionModalOpen = false;
    }



    //test

    public function addAnswerRow()
    {
        $this->answers[] = ['name' => ''];
    }
    public function editAnswerRow()
    {
        $this->answers[] = ['name' => ''];
    }


    // Remove chapter row by index
    public function removeAnswerRow($index)
    {
        unset($this->answers[$index]);
        $this->answers = array_values($this->answers); // Re-index the array
    }




    public function closeAnswerModal()
    {
        $this->isQuestionModalOpen = false;
    }

    public function closeEditAnswerModal()
    {
        $this->isEditQuestionModalOpen = false;
    }
    public function closeListQuestionModal()
    {
        $this->showListQuestion = false;
    }

    public  function closeQuestionDeleteConfirmation(){
        $this->isDeleteQuestionConfirmationOpen=false;
    }









    public  function confirmQuestionDelete($id){
        $this->edit_question_id = $id;
        $this->isDeleteQuestionConfirmationOpen = true;

    }



    public function deleteQuestionConfirmed()
    {


        $question= Question::findOrFail($this->edit_question_id);
        Question::findOrFail($this->edit_question_id)->delete();
         $this->questions= Question::query()->where('lesson_id',$question->lesson_id)->get();
        $this->closeQuestionDeleteConfirmation();

        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
    }
    public function render()
    {


        // dd($this->search_material_id);

        $classRooms = ClassRoom::query()->get();
        $lessons_list = Lesson::query()->when($this->search, function ($q) {
            $q->where('name', 'like', "%{$this->search}%");
        })
        ->when($this->search_class_room_id,function($q){
            $q->wherehas('materials',function($q){
                $q->where('class_room_id',$this->search_class_room_id);
            });
        })
            ->when($this->search_material_id,function($q){
                    $q->where('material_id',$this->search_material_id);
            })
            ->when($this->search_chapter_id,function($q){
                $q->where('chapter_id',$this->search_chapter_id);
            })

        ->orderBy('created_at', 'desc')->paginate(10);
        return view('livewire.lessons.lessons-component', [
            'lessons_list' => $lessons_list,
            'classRooms' => $classRooms,

        ])->layout('layouts.admin.master');
    }


    public $selectedAnswerIndex = null;

    public function toggleAnswerCorrect($index)
    {
        $this->selectedAnswerIndex = ($this->selectedAnswerIndex === $index) ? null : $index;

        // Ensure only one switch is selected
        foreach ($this->answers as $key => &$answer) {
            $answer['is_correct'] = ($key === $this->selectedAnswerIndex);
        }
    }

    public  function  saveQuestion()
    {

        $this->validate([
            'question' => 'required|string',
            'answers.*.name' => 'required|string',
            'answers.*.is_correct' => 'boolean',
        ]);
        $correctAnswers = array_filter($this->answers, function ($answer) {


            if (isset($answer['is_correct'])) {
                //return  null;


                return $answer['is_correct'];
            }
            return  false;
        });

        if (count($correctAnswers) !== 1) {
            $this->addError('answers', 'You must select exactly one correct answer.');
            return;
        }
        $questionAttachment=null;
        if($this->question_attachment) {
            $questionAttachment = $this->question_attachment->store('question_attachment', 'public');

        }
        $question = Question::query()->create([
            'questions' => $this->question,
            'lesson_id' => $this->lessonId,
            'attachment' => $questionAttachment
        ]);
        foreach ($this->answers as $key => $answer) {


            Answer::query()->create([
                'question_id' => $question->id,
                'answer' => $answer['name'],
                'is_correct' => $answer['is_correct']? 1 : 0,
            ]);
        }

        $correct = Answer::query()->where('question_id', $question->id)->where('is_correct', 1)->first();

        $question->update([
            'is_correct' => $correct->id,
        ]);

        $this->closeQuestionModal();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
    }


    public  function  openAllQuestionModal($id){


        $this->showListQuestion=true;
        $this->questions=Question::query()->where('lesson_id',$id)->get();
    }

    public function openExcelModal($id = null)
    {
        $this->lessonId = $id;
        $this->isExcelModalOpen = true;
    }

    public function closeExcelModal()
    {
        $this->isExcelModalOpen = false;
    }

    public function uploadExcel()
    {
        $this->validate([
            'file' => 'required|file|mimes:xlsx,xls|max:2048',
        ]);
        Excel::import(new QuestionImport($this->lessonId), $this->file->getRealPath());

        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
        $this->closeExcelModal();
    }

    public function  openQuestionModal($id){

        $this->reset(['question',   'answers']);
        $this->showListQuestion=false;
        $this->isEditQuestionModalOpen = true;


        $question=Question::query()->find($id);
        $this->edit_questions=$question->questions;
        $this->edit_question_id=$question->id;
        $this->show_question_attachment=$question->attachment;
        $this->edit_answers=Answer::query()->where('question_id',$question->id)->get();


    }

    public function saveEditQuestion(){
        $this->validate([
            'edit_questions' => 'required|string',
        ]);

        $question = Question::find($this->edit_question_id);
        $question->update(['questions' => $this->edit_questions]);

        // Update the answers
        foreach ($this->edit_answers as $index => $answerData) {
//            dd($answerData['answer']);
            Answer::where('id', $answerData['id'])->update([
                'answer' => $answerData['answer'],
                'is_correct' => $answerData['is_correct'] ?? false,
            ]);
        }
        $question=Question::query()->find($this->edit_question_id);
        $question->update([
           'questions'=>$this->edit_questions,
        ]);

        if($this->edit_question_attachment){
            $questionAttachment = $this->edit_question_attachment->store('question_attachment', 'public');
            $question->update([
                'attachment'=>$questionAttachment,
            ]);

        }
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
       // $this->reset('success');

        $this->closeEditAnswerModal();







    }


    public  function openVideoModal($id){
        $this->showVideoModal=true;
        $lesson=Lesson::query()->findOrFail($id);
        $this->vedioUrl=$lesson->getVedioUrl();
    }
    public  function closeVideoModal()
    {
        $this->showVideoModal=false;

    }

}
