<?php

namespace App\Livewire;
use Illuminate\Support\Facades\Session;

use Illuminate\Support\Facades\App;
use Livewire\Component;
//use Mcamara\LaravelLocalization\LaravelLocalization;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class LocaleSwitcher extends Component
{
    public $locale;


    public function mount()
    {
        // Set the current locale on mount
        $this->locale = app()->getLocale();
    }

    public function changeLocale($locale)
    {
//        dd($locale);
        // Validate locale
        $supportedLocales = ['en', 'ar']; // List your supported locales here

        if (in_array($locale, $supportedLocales)) {
            session(['locale' => $locale]);

            app()->setLocale($locale);
            session('locale', config('app.locale'));

        }
        $this->dispatch('localeChanged',\app()->getLocale());

    }


    public function render()
    {
        return view('livewire.locale-switcher');
    }
}
