<?php

namespace App\Livewire\Materials;

use App\Http\Requests\AddAttachmentRequest;
use App\Http\Requests\Admin\Chapters\ChapterMaterailRequest;
use App\Models\Chapter;
use App\Models\ClassRoom;
use App\Models\Exam;
use App\Models\Material;
use App\Models\MaterialAttachment;
use Illuminate\Mail\Attachment;
use Illuminate\Support\Facades\Storage;
use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\WithPagination;

class MaterialComponent extends Component
{

    use WithPagination;
    use WithFileUploads;
    public $openListChapter = false;
    public $isModalOpen = false;
    public $isDeleteConfirmationOpen = false;
    public $ischapterModalOpen = false;
    public $isExamModalOpen = false;
    public $isShowFilter=false;

    public $attahment='';
    public $title_attachment='';
    public $attachment_book=null;
    public  $isAddExamModalOpen=false;
    public  $code;
    public  $uploadProgress=[];
    public $exam_lists=[];
    // Updated properties
    public $name, $status = 1, $classRoomId, $materialId;
    public $search = '';
    public $attachment=null;
    public  $attachments=null;
    public  $urlAttachment=null;
    public $isAttachmentModalOpen=false;
    public $isExamListModalOpen=false;


    public $isAddAttachmentModalOpen=false;
    public  $exam_name='';
    public $urlSubjectPdf=null;
    // For multiple image uploads
    public $subjectPdf=null ; // For multiple PDF uploads
    public $defaultImageUrl = null; // Default image URL
    public $progress = []; // Track progress for each upload

    public $search_class_room_id = null;
    public $question_count='';
    public $sortField = 'name';
    public $sortDirection = 'asc';
    public $chapters = [['name' => '']];
    public $chapter_exams=[];
    public $chaptername_id;

    public $exams = [];
    public $materialChapters = []; // Assume this is populated with chapters
 public  $chapterIds = [];

    public function mount()
    {
        $this->defaultImageUrl = url('/storage/uploads/images/default.jpg');
        $this->exams[] = ['title' => '', 'chapter' => []];

    }












    public  function openModalAddExam($id){
        $this->isAddExamModalOpen=true;
        $this->reset(['exam_name',  'classRoomId', 'materialId','chapterIds','question_count']);
        $material=Material::query()->find($id);
        $this->classRoomId=$material->class_room_id;
        $this->materialId=$id;
        $this->chapter_exams=Chapter::query()->where('material_id',$id)->get();



    }

    public  function openModalExamList($id){
        $this->isExamListModalOpen=true;

        $this->exam_lists=Exam::query()->where('material_id',$id)->get();
    }
    public  function closeModalExamList()
    {
        $this->isExamListModalOpen=false;


    }

    public  function openModalListExam($id){
        $this->isAddExamModalOpen=true;
        $this->exam_lists=Exam::query()->where('material_id',$id)->get();


    }

    public function saveExam()
    {
        $this->validate([
            'exam_name' => 'required|string|max:255',
            'chapterIds' => 'required|array', // Validate as an array
            'chapterIds.*' => 'exists:chapters,id', // Validate each chapter ID
       'question_count'=>'required'
        ]);

//        dd($this->name);
        // Create or update the exam
        $exam = Exam::query()->create([
            'name' => $this->exam_name,
            'class_room_id' => $this->classRoomId,
            'material_id' => $this->materialId,
            'question_count'=>$this->question_count,
        ]);
        $exam->chapters()->sync($this->chapterIds);
        $this->closeModalAddExam();
        $this->dispatch('success', ['message' => 'تم تنفيد العملية بنجاح']);
    }


    public  function closeModalAddExam(){
        $this->isAddExamModalOpen=false;
    }

    public function showFilter(){
        $this->isShowFilter=true;
    }
    public function closeShowFilter(){
        $this->isShowFilter=false;

    }
    // Open modal for adding or editing material
    public function openModal($id = null)
    {
        $this->reset(['name', 'status', 'classRoomId', 'materialId', 'defaultImageUrl','code','attachment','subjectPdf']);
        $this->isModalOpen = true;

        if ($id) {
            $material = Material::findOrFail($id);
            $this->classRoomId = $material->class_room_id;
            $this->name = $material->name;
            $this->code = $material->code;

            $this->status = $material->status;
            $this->materialId = $material->id;
            $this->urlAttachment = $material->attachment ? url('/storage/' . $material->attachment) : $this->defaultImageUrl;
            $this->urlSubjectPdf = $material->subjectPdf ;// Adjusted for single PDF
        } else {
            $this->urlAttachment = $this->defaultImageUrl; // Reset to default image
            $this->urlSubjectPdf = null; // Reset PDF
        }


    }




    public function openModalChapter($id = null)
    {
        $this->reset(['name', 'classRoomId', 'materialId', 'chapters','attachment','code']);
        $this->ischapterModalOpen = true;

        if ($id) {
            $material = Material::findOrFail($id);
            $this->classRoomId = $material->class_room_id;
            $this->name = $material->name;
            $this->status = $material->status;
            $this->materialId = $material->id;
            $this->code = $material->code;
            if (empty($this->chapters)) {
                $this->chapters = [
                    [
                        'name' => '', // Default empty name
                        'material_id' => $this->materialId,
                        'is_correct' => $this->is_correct,
                    ]
                ];
            }
        }

    }


    public function openAddAttachmentModal($id = null)
    {
        $this->resetErrorBag(); // Clear previous validation errors

        $this->materialId=$id;
        $this->title_attachment='';
        $this->attahment='';
        // Reset and initialize attachments
        // if ($id) {
        //     $this->attachments = [
        //         [
        //             'title' => '',
        //             'attachment' => null,
        //             'material_id' => $id ?? $this->materialId, // Use the provided id or the existing materialId
        //             'uploadProgress' => 0, // Initialize upload progress
        //         ]
        //     ];
        // }

        $this->uploadProgress = []; // Reset upload progress tracking
        $this->isAddAttachmentModalOpen = true; // Open the modal
    }

    public  function addChapterRow(){
        $this->chapters[] = [
            'name' => '',
            'title' => '',

            'description' => '', // Default empty name


        ];

    }

    public function removeChapterRow($index)
    {
        unset($this->chapters[$index]);
    }
    public function addAttachmentRow()
    {

        $this->attachments[] = [
            'title' => '',
            'attachments' => '', // Default empty name
                ];

        $this->uploadProgress[] = 0; // Initialize progress for the new attachment

    }

    public function closeAddAttachmentModal()
    {

        $this->isAddAttachmentModalOpen = false;
    }

    // Remove chapter row by index
    public function removeAttachmentRow($index)
    {
        unset($this->attachments[$index]);
        unset($this->uploadProgress[$index]);
        $this->attachments = array_values($this->attachments); // Reindex the array
        $this->uploadProgress = array_values($this->uploadProgress); // Reindex progress array
    }


    public function openAttachmentModal($id = null)
    {
        $this->reset(['attachments']);
        $this->isAttachmentModalOpen = true;

        if ($id) {
            $this->attachments = MaterialAttachment::query()->where('material_id',$id)->get();
        }

    }

    public function closeAttachmentModal()
    {

        $this->isAttachmentModalOpen = false;
    }


    public  function  openModalAddLesson($id=null){

        $this->reset(['name', 'classRoomId', 'materialId', 'chapters','attachment','code']);
        $this->ischapterModalOpen = true;

        if ($id) {
            $material = Material::findOrFail($id);
            $this->classRoomId = $material->class_room_id;
            $this->name = $material->name;
            $this->status = $material->status;
            $this->materialId = $material->id;
            $this->code = $material->code;

            // Initialize with default chapter data if not already present
            if (empty($this->chapters)) {
                $this->chapters = [
                    [
                        'name' => '', // Default empty name
                        'material_id' => $this->materialId,
                        'is_correct' => $this->is_correct,
                    ]
                ];
            }
        }

    }
    // Save chapter details


    public function saveAttachments()
    {

        // $this->validate(app(AddAttachmentRequest::class)->rules());



        $material=Material::find($this->materialId);

        $classRoom=ClassRoom::query()->find($material->class_room_id);

        $destinationPath = $classRoom->code . '/' . $material->code . '/materials/'; // Append the file name only
        $attachmentPath = $this->attachment_book->store($destinationPath, 'public');

                // $attachmentPath = $this->attachment_book->store('attachments', 'public');

                MaterialAttachment::create([
                    'title' => $this->title_attachment,
                    'attachment' => $attachmentPath,
                    'material_id' => $this->materialId,
                ]);
        $this->closeAddAttachmentModal();
        $this->dispatch('success', ['message' => 'تم تنفيذ العملية بنجاح']);

    }

    public function saveChapter()
    {

        $this->validate(app(ChapterMaterailRequest::class)->rules());

        foreach ($this->chapters as $chapterData) {
            Chapter::query()->create([
                'name' => $chapterData['name'],
                'title' => $chapterData['title'],
                'description' => $chapterData['description'],

                'class_room_id'=>$this->classRoomId,
                'material_id'=>$this->materialId,
            ]);
        }

        $this->closeChapterModal();
        $this->dispatch('success', ['message' => 'تم تنفيذ العملية بنجاح']);

    }
    public function closeChapterModal()
    {
        $this->ischapterModalOpen = false;
    }
    // Close modals
    public function closeModal()
    {
        $this->isModalOpen = false;
    }


    public function updatedAttachment()
    {
        // Assuming you're saving the attachment to storage here
        $this->validate([
            'attachment' => 'image|max:2048', // Validate as per your requirements
        ]);

        $attachmentPath = $this->attachment->store('material', 'public');

        // If you want to store the URL of the uploaded file
        $this->urlAttachment = Storage::url($attachmentPath);

        // Optional: Clear previous attachment URL if desired
        // $this->urlAttachment = null; // Uncomment this line if you want to clear it after upload
    }

    // Save material
    public function save()
    {
        $subjectPdfPath = null;
        $attachmentPath = null;

        $validatedData = $this->validate([
            'name' => 'required|string|max:255',
            'classRoomId' => 'required|exists:class_rooms,id',

            // Conditionally required or nullable for attachment
            'attachment' => ($this->materialId ? 'nullable' : 'required') . '|file|mimes:jpg,png,jpeg|max:2048',

            'status' => 'nullable|boolean',
            'code' => 'required',
        ]);

        // Store attachment if exists
        if ($this->attachment) {
            $attachmentPath = $this->attachment->store('material', 'public');
        }

        // Store subject PDF if exists
        if ($this->subjectPdf) {
            $subjectPdfPath = $this->subjectPdf->store('material', 'public');
        }
        $material = Material::find($this->materialId);

        // Store new attachment if provided, otherwise keep existing
        if ($this->attachment) {

            $classRoom=ClassRoom::query()->find($this->classRoomId);
            $destinationPath = $classRoom->code . '/' . $this->code . '/materials/'; // Append the file name only
            $attachmentPath = $this->attachment->store($destinationPath, 'public');
        } else {
            $attachmentPath = $material ? $material->attachment : null;
        }

        // Store new subject PDF if provided, otherwise keep existing
        if ($this->subjectPdf) {
            $subjectPdfPath = $this->subjectPdf->store('material', 'public');
        } else {
            $subjectPdfPath = $material ? $material->subjectPdf : null;
        }

        Material::updateOrCreate(
            ['id' => $this->materialId],
            [
                'name' => $validatedData['name'],
                'class_room_id' => $validatedData['classRoomId'],
                'status' => $this->status ? 1 : 0,  // Set status based on input
                'attachment' => $attachmentPath,  // Save attachment or keep existing
                'code' => $this->code,
                'subjectPdf' => $subjectPdfPath,  // Save subject PDF or keep existing
            ]

        );

        // Close modal and dispatch success message
        $this->closeModal();
        $this->dispatch('success', ['message' => 'تم تنفيذ العملية بنجاح']);
    }

    // Confirm delete action
    public function confirmDelete($id)
    {
        $this->materialId = $id;
        $this->isDeleteConfirmationOpen = true;
    }

    // Close delete confirmation modal
    public function closeDeleteConfirmation()
    {
        $this->isDeleteConfirmationOpen = false;
    }

    // Perform delete action
    public function deleteConfirmed()
    {
        Material::findOrFail($this->materialId)->delete();
        $this->closeDeleteConfirmation();
        $this->dispatch('success', ['message' => 'تم تنفيذ العملية بنجاح']);
    }

    // Reset pagination on search update
    public function updatingSearch()
    {
        $this->resetPage();
    }



    public function sortBy($field)
    {
        $this->sortDirection = $this->sortField === $field ? ($this->sortDirection === 'asc' ? 'desc' : 'asc') : 'asc';
        $this->sortField = $field;
    }




    public function render()
    {
        $classRooms = ClassRoom::query()
            ->active()
            ->get();
        $this->dispatch('loadContactDeviceSelect2');  // Emit the event to trigger Select2 initialization

        $materials = Material::query()
            ->where('name', 'like', "%{$this->search}%")

            ->WhereHas('classRooms', function ($q){
                $q ->where('id', 'like', "%{$this->search_class_room_id}%");

            })

            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate(10);

        return view('livewire.materials.material-component', [
            'classRooms' => $classRooms,
            'materials' => $materials,

        ])->layout('layouts.admin.master');
    }





    public function addExamRow()
    {
        $this->exams[] = ['title' => '', 'chapter' => []];
    }

    public function removeExamRow($index)
    {
        unset($this->exams[$index]);
        // Reindex the exams array to prevent index gaps
        $this->exams = array_values($this->exams);
    }


    public function onClassRoomChange()
    {
        $this->materials = Material::where('class_room_id', $this->classRoomId)->get();

        if (!Material::where('class_room_id', $this->classRoomId)->where('id', $this->materialId)->exists()) {
            $this->materialId = null;
        }
    }
    public function closeModalExam()
    {
        $this->isExamModalOpen = false;
    }

    public function openExamModal()
    {
        $this->isExamModalOpen = true;
    }


    public  function openModalListChapter($id){
        $this->reset(['name', 'classRoomId', 'materialId', 'chapters','attachment']);

        $this->openListChapter=true;

        $this->chapters=Chapter::query()->where('material_id',$id)->get();

    }
    public  function closeModalListChapter(){
        $this->openListChapter=false;
    }
}
