<?php

namespace App\Livewire\StudentProfile;

use Livewire\Component;

class StudentProfileComponent extends Component
{

    public $studentId;

    // The mount method is where you handle route parameters
    public function mount($id)
    {
        // Assign the route parameter to the public property
        $this->studentId = $id;

        // You can now load the student data using the ID
        // $this->student = Student::find($this->studentId);
    }
    public function render()
    {
        return view('livewire.student-profile.student-profile-component',[
            'student' => \App\Models\Student::find($this->studentId),  // Fetch the student data

        ])->layout('layouts.admin.master');
    }
}
