<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;

class Admin extends Authenticatable
{
    use HasFactory;

    protected $guarded=[];
    public  function  getPhoto(){
        if (!$this->photo){
            return asset('assets/media/avatars/300-1.jpg');
        }

        return  asset('storage/'.$this->photo);
    }
    public function roles(){
        return $this->belongsTo(Role::class,'role_id','id');
    }
    public function hasAbility($permissions)
    {

        $role = $this->roles;

        if (!$role) {
            return false;
        }

//        if(auth('admin')->user()->is_supper){
//            return true;
//
//        }


        foreach ($role->permissions as $value) {
            if (is_array($permissions) && in_array($value->key, $permissions)) {
                return true;
            } else if (is_string($permissions) && strcmp($permissions, $value->key) == 0) {
                return true;
            }
        }
        return false;
    }
}
