<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Chapter extends Model
{
    use HasFactory ,SoftDeletes;
    protected $guarded=[];


    public function getStatus(){
        if ($this->status) {
            return '<span class="badge badge-success">فعال</span>';
        } else {
            return '<span class="badge badge-danger">غير فعال</span>';
        }

    }

    public function  classRooms(){
        return $this->belongsTo(ClassRoom::class,'class_room_id','id');
    }
    public function  materials(){
        return $this->belongsTo(Material::class,'material_id','id');
    }

    public function  lessons(){
        return $this->hasMany(Lesson::class,'chapter_id','id');
    }




    public  function questions(){

        return  Question::query()->wherehas('lessons',function ($q){
           $q->where('chapter_id',$this->id);
        })->count();
//        return $this->lessons()->questions()->count();
    }

    public function  numberOfLessons(){
        return $this->lessons()->count()??0;
    }

    public  function  scopeActive($query){

        return $query->where('status',1);
    }
}
