<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClassPeriod extends Model
{
    use HasFactory;
    protected $guarded=[];

    public  function  materials(){
        return $this->belongsTo(Material::class,'material_id','id');
    }

    public  function  labs(){
        return $this->belongsTo(Lab::class,'lab_id','id');
    }
    public  function  classRooms(){
        return $this->belongsTo(ClassRoom::class,'class_room_id','id');
    }

    public  function  teachers(){
        return $this->belongsTo(Admin::class,'teacher_id','id');
    }
    public  function  classSections(){
        return $this->belongsTo(ClassSection::class,'class_section_id','id');
    }


    public function getDate()
    {
        switch ($this->date) {
            case 1:
                return 'الاثنين';
            case 2:
                return 'الثلاثاء';
            case 3:
                return 'الأربعاء';
            case 4:
                return 'الخميس';
            case 5:
                return 'الجمعة';
            case 6:
                return 'السبت';
            case 0:
                return 'الأحد';
            default:
                return 'يوم غير محدد';
        }
    }




}
