<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class ClassRoom extends Model
{
    use HasFactory, SoftDeletes;
    protected $guarded=[];



    public function materials(){
        return $this->hasMany(Material::class,'class_room_id','id');
    }
    public function getStatus(){
        if ($this->status) {
            return '<span class="badge badge-success">فعال</span>';
        } else {
            return '<span class="badge badge-danger">غير فعال</span>';
        }

    }

    public  function  scopeActive($query){

        return $query->where('status',1);
    }





}
