<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Contest extends Model
{
    use HasFactory;
    public  $guarded=[];


    public function students(){
        return $this->belongsToMany(Student::class,'contest_students','contest_id','student_id','id','id')->withPivot('mark');
    }

    public function materials(){
        return $this->belongsTo(Material::class,'material_id','id');
    }
    public function isAvailable() {
        // Get the current time in the Gaza timezone (or default timezone)
        $currentTime = Carbon::now('Asia/Gaza')->toTimeString(); // Current time formatted as H:i:s

        // Check if there's a contest with the specified conditions
        return self::where('id', $this->id)
            ->whereDate('date', Carbon::today()->format('Y-m-d')) // Ensure date is today
            ->where('start_time', '<=', $currentTime) // Start time should be before or equal to now
            ->where('end_time', '>=', $currentTime)  // End time should be after or equal to now
            ->exists(); // Use exists() to check if any records match the criteria
    }



    public function questions(){
        return $this->hasMany(ContestQuestion::class,'contest_id','id');
    }


    public function getDurationAttribute($value)
    {
        if ($value) {
            // احسب الوقت بعد إضافة duration
            $time = Carbon::now()->addMinutes($value);

            // تأكد أن end_time هو كائن Carbon
            $endTime = Carbon::createFromFormat('H:i:s', $this->end_time);

            if ($time > $endTime) {
                // احسب الوقت المتبقي حتى end_time
                $remainingTime = Carbon::now()->diffInMinutes($endTime, false);

                // تحقق إذا كان الوقت المتبقي غير سلبي
                return $remainingTime > 0 ? $remainingTime : 0;
            }

            // إذا كان الوقت المحدد أقل من end_time
            return $value;
        }

        return null; // إذا لم تكن duration محددة
    }


    public function levels(){
        return $this->belongsTo(Level::class,'level_id','id');
    }

    public function getMark(){

        $mark=null;
       $contestStudnent=   ContestStudent::query()->where('student_id',auth('sanctum')->id())->where('contest_id',$this->id)->first();

       if(auth('sanctum')->id()){
       if($contestStudnent){
        $mark= $contestStudnent->mark;
       }
    }

    return $mark;



    }

    // public function illustrations() {
    //     return $this->hasManyThrough(illustrationContest::class,IllustrationContestQuestion::class,'illustration_contest_id','contest_id','id','id');
    // }

    public function  illustrations(){
        return $this->hasMany(illustrationContest::class,'contest_id','id');

    }
    public function questionsWithoutIllustrations()
    {

        return $this->questions()->where('contest_id',$this->id)->whereDoesntHave('illustrations');
    }

    // illustration_contest_question

    public function getAttachment(){
    if(!$this->photo){
        return asset('default.jpg');
    }

    return asset('storage/'.$this->photo);
    }

    public function models(){

        return $this->hasMany(Contestmodel::class,'contest_id','id');

    }
// Casting
protected $casts = [
    'correct_code' => 'boolean',
];

}
