<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContestQuestion extends Model
{
    use HasFactory;
    public  $guarded=[];



    public function answers()
    {
        return $this->hasMany(ContestAnswer::class, 'question_contest_id', 'id');
    }

    public  function  getAttachments(){
        return asset('storage/'.$this->attachment);
    }

    public function illustrations(){
        return $this->belongsToMany(illustrationContest::class,'illustration_contest_question','question_id','illustration_contest_id','id','id')->withPivot('contest_id');
    }

    public function contests(){
        return $this->belongsTo(Contest::class,'contest_id','id');
    }

}
