<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Governorate extends Model
{
    use HasFactory;
    protected  $guarded=[];


    public function getStatus(){
        if ($this->status) {
            return '<span class="badge badge-success">فعال</span>';
        } else {
            return '<span class="badge badge-danger">غير فعال</span>';
        }

    }

    public  function  eductionAreas(){
        return $this->hasMany(EducationalArea::class,'governorate_id','id');
    }

    public  function  educationAreaCount(){
        return $this->eductionAreas()->count()??0;
    }
    public  function  scopeActive($query){
        return $query->where('status',1);
    }

}
