<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;

class Grade extends Model
{
use HasFactory, SoftDeletes, HasTranslations;

// Specify the table name if it's different from the plural of the model name
protected $table = 'grades';

// Specify the attributes that are mass assignable
protected $fillable = ['name', 'note'];

// Define the translatable attributes
public $translatable = ['name'];
    public function scopeSearch($query, $search)
    {
        if ($search) {
            $query->where('name->ar', 'like', "%{$search}%")
                ->orWhere('name->en', 'like', "%{$search}%");
        }
    }
}


