<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lesson extends Model
{    use HasFactory ,SoftDeletes;
    protected $guarded=[];

    public function chapters(){
        return $this->belongsTo(Chapter::class,'chapter_id','id');
    }
    public function materials(){
        return $this->belongsTo(Material::class,'material_id','id');
    }

    public  function questions(){
        return $this->hasMany(Question::class,'lesson_id','id');
    }




    public  function getVedioUrl(){
        $materials=Material::query()->find($this->material_id);
        $classRoom=$materials->classRooms?$materials->classRooms->code:null;
        $chapter=Chapter::query()->find($this->chapter_id);


        return $this->attachment? asset('storage/'.$classRoom.'/'.$materials->code.'/videos/'.$chapter?->name.'/'.$this->attachment):null;
}

    public function isWatchLesson()
    {
        $user = auth('sanctum')->user();
        return  $user?$user->watchLessons()->where('lesson_id', $this->id)->exists():false;
    }



    public function watchLessons()
    {
        return $this->belongsToMany(Student::class, 'student_watch_lessons',  'lesson_id','student_id')
            ->withTimestamps();
    }




    // Check if the authenticated user has marked the lesson
    public function isMarkLesson()
    {
        $user = auth('sanctum')->user();
        return  $user?$user->markLessons()->where('lesson_id', $this->id)->exists():false;

    }
public  function getPhotoUrl(){

    return asset('storage/'.$this->cover_attachment);
}

//    public  function

}

