<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Material extends Model
{
    use HasFactory;
    protected $guarded=[];

    public  function  classRooms(){
        return $this->belongsTo(ClassRoom::class,'class_room_id','id');
    }

    public  function  chapters(){
        return $this->hasMany(Chapter::class,'material_id','id');
    }
    public  function  lessons(){
        return $this->hasMany(Lesson::class,'material_id','id');
    }

    public function exams(){
        return $this->hasMany(Exam::class,'material_id','id');
    }

    public  function attachments(){
        return $this->hasMany(MaterialAttachment::class,'material_id','id');
    }

//    public function watchLessons()
//    {
//        return $this->belongsToMany(Lesson::class, 'student_watch_lessons', 'student_id', 'lesson_id')
//            ->withTimestamps();
//    }

    public function getWatchRatioAttribute()
    {
        // Count the total number of lessons
        $totalLessons = $this->lessons()->count();

        $watchedLessons = $this->lessons()->whereHas('watchLessons')->count();

        return $totalLessons > 0 ? ($watchedLessons / $totalLessons) * 100 : 0;
    }

    public  function  avgLessons(){

    }
    public  function numberOfChapters(){
        return $this->chapters()->count()??0;
    }
    public function getStatus(){
        if ($this->status) {
            return '<span class="badge badge-success">فعال</span>';
        } else {
            return '<span class="badge badge-danger">غير فعال</span>';
        }

    }

    public function getAttachment(){
        return asset('storage/'.$this->attachment);
    }
}
