<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;
    protected $guarded=[];

    public function getAttachment(){
        if($this->notification_type=='general'){

            return asset('assets/notifications/general.png');
        }else{
            return asset('assets/notifications/Groups.png');

        }
    }

    public function trafficViolations(){
        return $this->belongsTo(TrafficViolation::class,'traffic_violation_id','id');
    }
}
