<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Question extends Model
{
    use HasFactory;
    protected $guarded=[];



    public function  lessons(){
        return $this->belongsTo(Lesson::class,'lesson_id','id');
    }

    public  function  answers(){
        return $this->hasMany(Answer::class,'question_id','id');
    }

    public  function  getAttachments(){
        return asset('storage/'.$this->attachment);
    }
}
