<?php

namespace App\Providers;

// use Illuminate\Support\Facades\Gate;
use App\Models\PermissionElement;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        //
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        $permissions = PermissionElement::get();

        foreach ($permissions as $permission) { // Assume $permission is an instance or an object of PermissionElement

            // If $permission has a 'key' property, use it to define the gate
            if (isset($permission->key)) {
                Gate::define($permission->key, function ($auth) use ($permission) {

                    return $auth->hasAbility($permission->key);
                });
            }
        }

    }
}
