<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
@include('layouts.auth.include.head')
<body id="kt_body" class="app-blank bgi-size-cover bgi-attachment-fixed bgi-position-center bgi-no-repeat">
<script>
    var defaultThemeMode = "light";
    var themeMode;
    if (document.documentElement) {
        if (document.documentElement.hasAttribute("data-bs-theme-mode")) {
            themeMode = document.documentElement.getAttribute("data-bs-theme-mode");
        } else {
            themeMode = localStorage.getItem("data-bs-theme") || defaultThemeMode;
        }
        if (themeMode === "system") {
            themeMode = window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light";
        }
        document.documentElement.setAttribute("data-bs-theme", themeMode);
    }
</script>

<div class="d-flex flex-column flex-root" id="kt_app_root">
    <style>
        body { background-image: url('{{ asset('assets/media/auth/bg4.jpg') }}'); }
        [data-bs-theme="dark"] body { background-image: url('{{ asset('assets/media/auth/bg4-dark.jpg') }}'); }
    </style>

    @if (session('success'))
        <div class="alert alert-success d-flex align-items-center p-5">
            <span class="svg-icon svg-icon-2hx svg-icon-success me-3">
                <!-- Success Icon -->
            </span>
            <div class="d-flex flex-column">
                <h4 class="mb-1 text-success">نجاح العملية</h4>
                <span>{{ session('success') }}</span>
            </div>
            <button type="button" class="btn-close ms-2" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger d-flex align-items-center p-5">
            <span class="svg-icon svg-icon-2hx svg-icon-danger me-3">
                <!-- Error Icon -->
            </span>
            <div class="d-flex flex-column">
                <h4 class="mb-1 text-danger">فشل العملية</h4>
                <span>{{ session('error') }}</span>
            </div>
            <button type="button" class="btn-close ms-2" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="d-flex flex-column flex-column-fluid flex-lg-row">
        <div class="d-flex flex-center w-lg-50 pt-15 pt-lg-0 px-10">
            <div class="d-flex flex-center flex-lg-start flex-column">
                <a href="#" class="mb-7">
                    <img alt="Logo" src="{{asset('storage/'.settings('general','coverLogo')->value)}}" width="200px" />
                </a>
                <h2 class="text-white fw-normal m-0">مرحبا بك في {{settings('general','name')->value}}</h2>
            </div>
        </div>

        <div class="d-flex flex-column-fluid flex-lg-row-auto justify-content-center justify-content-lg-end p-12 p-lg-20">
            <div class="bg-body d-flex flex-column align-items-stretch flex-center rounded-4 w-md-600px p-20">
                <div class="d-flex flex-center flex-column flex-column-fluid px-lg-10 pb-15 pb-lg-20">
                    <form class="form w-100" method="post" novalidate="novalidate" data-kt-redirect-url="{{ route('index') }}" action="{{ route('postLogin') }}">
                        @csrf
                        <div class="text-center mb-11">
                            <img src="{{asset('storage/'.settings('general','coverLogo')->value)}}" alt="Logo" class="mb-5" style="width: 100px; height: auto;">
                            <h1 class="text-dark fw-bolder mb-3">تسجيل  الدخول</h1>
                        </div>

                        <div class="fv-row mb-8">
                            <input type="text" placeholder="Email" name="email" autocomplete="off" class="form-control bg-transparent" />
                            @error('email')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="fv-row mb-3">
                            <input type="password" placeholder="Password" name="password" autocomplete="off" class="form-control bg-transparent" />
                            @error('password')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="d-flex flex-stack flex-wrap gap-3 fs-base fw-semibold mb-8">
                            <div></div>
                            <a href="" class="link-primary">نسيت كلمة المرور</a>
                        </div>

                        <div class="d-grid mb-10">
                            <button type="submit" id="kt_sign_in_submit" class="btn btn-primary">
                                <span class="indicator-label">تسجيل الدخول</span>
                                <span class="indicator-progress">Please wait...
                                    <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                            </button>
                        </div>
                    </form>
                </div>

                <div class="d-flex flex-stack px-lg-10">
                    <div class="me-0">

                    </div>
                </div>


            </div>
        </div>
    </div>
</div>

@include('layouts.auth.include.script')
</body>
</html>
