{{-- <script src="{{ asset('assets/js/jquery.min.js') }}"></script> --}}
<script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('assets/js/additional-methods.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/localization/messages_ar.js"></script>
<script>
    $(document).ready(function() {


        // DataTable initialization
        $(document).ready(function() {
            var table = $('#data-table').DataTable({
                processing: true, // Show processing indicator
                serverSide: true, // Enable server-side processing
                ajax: {
                    url: "{{ route('dashboard.achievements.getIndex') }}", // Replace with your route or API endpoint
                    type: 'GET', // HTTP method (e.g., GET, POST)
                    data: function(d) {
                        // Additional data to send with the request
                        d.search_contest_id = $('#search_contest_id')
                    .val(); // Example filter
                    }
                },
                columns: [{
                        data: 'student_name',
                        name: 'students.name'
                    }, // Student name
                    {
                        data: 'id_number',
                        name: 'students.id_number'
                    }, // ID number
                    {
                        data: 'contest_name',
                        name: 'contests.name'
                    },
                    {
                        data: 'mark',
                        name: 'mark'
                    }, // Contest name

                    // Contest name
                ],
                order: [
                    [0, 'desc']
                ], // Default sort (by ID in descending order)
                pageLength: 10, // Number of rows per page
                responsive: true, // Enable responsiveness
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.11.5/i18n/Arabic.json' // Localization (adjust if needed)
                }
            });

            // Custom filter example


            $('#search_contest_id').on('change', function() {
                table.draw();
            });
        });

        $(document).ready(function() {
            $('#exportExcelBtn').on('click', function() {
                let search = $('#dataTable').DataTable()
            .search(); // Get the current DataTable search value
                let searchContestId = $('#search_contest_id').val(); // Example filter field

                $.ajax({
                    url: "{{ route('dashboard.achievements.excel') }}",
                    type: "POST",
                    data: {
                        search: search,
                        search_contest_id: searchContestId,
                        _token: "{{ csrf_token() }}" // Include CSRF token for security
                    },
                    xhrFields: {
                        responseType: 'blob' // This is necessary for downloading files
                    },
                    success: function(response) {
                        // Create a link element to download the file
                        let url = window.URL.createObjectURL(response);
                        let a = document.createElement('a');
                        a.href = url;
                        a.download = 'contest_students.xlsx';
                        document.body.appendChild(a);
                        a.click();
                        a.remove();
                    },
                    error: function(xhr, status, error) {
                        console.error('Excel export failed:', error);
                        alert('Failed to export data. Please try again.');
                    }
                });
            });
        });

        // Search filter
        $('[data-kt-data-table-filter="search"]').on('keyup', function() {
            table.search(this.value).draw();
        });






        // Handle modal view and edit actions
        $(document).on('click', '.view, .edit', function() {
            const action = $(this).hasClass('view') ? 'view' : 'add_edit';
            const title = $(this).hasClass('view') ? 'عرض بيانات  مستخدمين النظام' :
                'تعديل بيانات مستخدمين النظام';

            const form = $('#my-form'); // The form you want to set the action for
            // Set the action attribute of the form
            form.attr('action', "{{ route('dashboard.admins.update') }}");

            const fields = [
                'name',
                'email',
                'admin_id',
                'phone'

            ];

            fields.forEach(field => {
                $('#' + action + '_' + field).val($(this).data(field));
            });

            $('#add_edit_role_id').val($(this).data('role_id')).trigger('change.select2');
            $('.modal-title').text(title);
            $('#kt_modal_' + action).modal('show');
        });



    });












    // Delete button click

    $(document).on('click', '.delete', function(e) {
        e.preventDefault();
        var name_delete = $(this).data('name_delete');
        var ids = $(this).data('id');
        $('#Delete_id').val(ids);
        $('#Name_Delete').val(name_delete);
        $('#confirmModal').modal('show');
    });
    // Confirm delete action
    $(document).on('click', '.delete_submit', function(e) {
        e.preventDefault();

        var ids = $('#Delete_id').val();
        $('#confirmModal').modal('hide');

        // Perform the AJAX delete request
        $.ajax({
            url: '{{ route('dashboard.achievements.delete') }}',
            method: 'POST',
            data: {
                "id": ids,
                "_token": "{{ csrf_token() }}"
            },
            success: function(response) {
                if (response.success) {
                    // Show success notification
                    toastr.success(response.message, 'Success', {
                        timeOut: 3000
                    });

                    // Reload the DataTable
                    $('#data-table').DataTable().ajax.reload();
                } else {
                    // Show error notification
                    toastr.error(response.message, 'Error', {
                        timeOut: 3000
                    });
                }
            },
            error: function(xhr) {
                // Hide the spinner and enable the submit button

                // For other errors, display a general error message
                toastr.error('هناك خطا ما يرجى المحاولى لاحقا',
                    'فشل العملية', {
                        timeOut: 3000
                    });


            }
        });
    });
</script>
