<div class="modal fade" id="kt_modal_add_edit" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h5 class="modal-title">اضافة مسابقة جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <!-- Modal Body -->
            <form id="my-form" action="{{ route('dashboard.contestModels.store') }}" method="post"
                enctype="multipart/form-data">


                @csrf
                <div class="modal-body">
                    <!-- Name and Email Fields -->
                    <input type="hidden" id="add_edit_contest_model_id" name="contest_model_id"
                        class="form-control form-control-solid">


                    <div class="form-group row">
                        <div class="form-group mb-3 row">
                            <div class="col-lg-6 col-sm-12">
                                <label for="add_edit_title" class="form-label">
                                    الاسم
                                    <span class="required"></span>
                                </label>
                                <input type="text" id="add_edit_title" name="title"
                                    class="form-control form-control-solid">
                                @error('title')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <input type="hidden" name="contest_id" id="add_edit_attachment_contest_id">

                            <div class="col-lg-6 col-sm-12">
                                <label for="attachment_book" class="form-label">المرفق <span class="required"></span></label>

                                <input type="file" id="attachment_book " name="attachment_book"
                                    class="form-control form-control-solid" accept="application/pdf">

                                @error('attachment')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror

                                <div class="mb-3">
                                    <a href="#" id="attachment" target="_blank">
                                    <img id="add_edit_image-preview" src="#" alt="Image Preview"
                                        style="display:none; max-width: 100px;">
                                    </a>
                                </div>


                            </div>
                        </div>
                    </div>


                </div>
                <div class="form-group row">
                    <div class="form-group mb-3 row">
                        <div class="col-lg-6 col-sm-12">

                            <select class="form-select ms-2 form-control form-control-solid w-210px ps-12"
                                data-dir="rtl" style="width: 100%" id="add_edit_contest_id" data-control="select2"
                                name="contest_id" data-placeholder="المستويات التعليمية ">
                                <option value="-1" selected>المستويات التعليمية</option>
                                <option value="">المستويات التعليمية</option>
                                @foreach ($contests as $value)
                                    <option value="{{ $value->id }}">{{ $value->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Modal Footer -->
                <div class="modal-footer">
                    <!-- Submit Button -->
                    <button type="submit" class="btn btn-primary" form="my-form">
                        <i class="ki ki-submit-duotone fs-2"></i>تاكيد
                    </button>

                    <!-- Cancel Button -->
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                        <i class="ki ki-times-duotone fs-2"></i> الغاء
                    </button>

                    <!-- Spinner (hidden initially) -->
                    <div id="spinner" class="spinner-border text-primary" role="status" style="display:none;">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>

            </form>
        </div>
    </div>
</div>
