{{-- <script src="{{ asset('assets/js/jquery.min.js') }}"></script> --}}
<script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('assets/js/additional-methods.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/localization/messages_ar.js"></script>
<script>
    $(document).ready(function() {
        function previewImage(event, previewSelector) {
            const output = $(previewSelector);
            output.attr('src', URL.createObjectURL(event.target.files[0])).show();
        }
        $('#add_edit_photo').on('change', function(event) {
            previewImage(event, '#add_edit_image-preview');
        });
        $(".date").flatpickr();
        flatpickr(".time", {
            enableTime: true, // Enable time picker
            noCalendar: true, // Disable calendar view
            dateFormat: "h:i", // 12-hour format with AM/PM
            time_24hr: false // Use 24-hour format
        });

        // Reset form and hide previews when modal is closed
        $('#kt_modal_add_edit').on('hidden.bs.modal', function() {
            $('.error').text('');
            $('#my-form').attr('action', "{{ route('dashboard.contestModels.store') }}");
            $('.card-title').text('اضافة نماذج مسابقات  جديدة');

            $('#my-form')[0].reset();
            // $('#add_edit_photo').hide();
            $('#add_edit_contest_id').val('').trigger('change.select2');


        });


        $('#search_contest_id').on('change', function() {
            table.draw();
        });
        // DataTable initialization
        var table = $('#data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('dashboard.contestModels.getIndex') }}",
                data: function(d) {
                    d.search_contest_id = $('#search_contest_id').val();

                },
            },
            columns: [


                {
                    data: 'attachment',
                    name: 'attachment'
                },

                {
                    data: 'title',
                    name: 'title',
                },
                {
                    data: 'contests',
                    name: 'contests',
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
            ],
            order: [
                [1, 'desc']
            ]
        });

        // Search filter
        $('[data-kt-data-table-filter="search"]').on('keyup', function() {
            table.search(this.value).draw();
        });



        // Show modal if needed
        if ($('#show_modal').val()) {
            $('#kt_modal_add_edit').modal('show');
        }

        // Form validation and AJAX submit
        $('#my-form').validate({
            rules: {
                title: {
                    required: true,
                },

                attachment_book: {
                    required: function() {
                        return $('#add_edit_contest_model_id').val() === '';
                    },
                },
                contest_id: {
                    required: true,

                },
                duration: {
                    required: true,

                },

                start_time: {
                    required: true,

                },
                end_time: {
                    required: true,

                },
                question_count: {
                    required: true,

                }


            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages
                $('#submit-button').prop('disabled',
                    true); // Disable submit button to prevent multiple submissions

                var url = $('#my-form').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        // Handle the response on success
                        if (response.success) {
                            toastr.success(response.message,
                                'نجاح العملية', {
                                    timeOut: 3000
                                });
                            $('#kt_modal_add_edit').modal('hide');
                            $('#data-table').DataTable().ajax.reload();
                        } else {
                            toastr.error(response.message, 'Error', {
                                timeOut: 3000
                            });
                        }
                    },
                    error: function(xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            // Loop through the validation errors and display them with toastr
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                // Show the error messages in the corresponding fields
                                var errorContainer = $('#' + field + '_error');
                                errorContainer.text(messages.join(', '))
                                    .show(); // Join messages if there are multiple
                            });
                        } else {
                            // For other errors, display a general error message
                            toastr.error(
                                '{{ __('messages.An error occurred. Please try again later') }}',
                                'Error', {
                                    timeOut: 3000
                                });
                        }
                    }
                });
            }
        });



        $(document).on('click', '.edit', function() {
            $('modal-title').text('تعديل نموذج المسابقة ')
            var contestId = $(this).data('contest_id');
            var contestModelId = $(this).data('contest_model_id');
            var attachment = $(this).data('attachment');
            var title = $(this).data('title');
            const imagePreview = $('#add_edit_image-preview');
            $('#add_edit_image-preview').show();
            imagePreview.attr('src', "{{asset('assets/media/svg/files/pdf.svg')}}");
            $('#add_edit_contest_id').val(contestId).trigger('change.select2');
            $('#my-form').attr('action', "{{ route('dashboard.contestModels.update') }}");
            $('#add_edit_title').val(title);
            $('#add_edit_contest_model_id').val(contestModelId);
            $('#kt_modal_add_edit').modal('show');
        });

        // Change event for material selection



        $(document).on('click', '.upload_excel', function() {
            $('#addExcelModal').modal('show');
            var contest_id = $(this).data('contest_id');
            $('#excel_upload_contest_id').val(contest_id);
        });

        $(document).on('click', '.add_question', function() {
            var contest_id = $(this).data('contest_id');
            $('#add_question_contest_id').val(contest_id);
            $('#addQuessatioModal').modal('show');
        });


        $.validator.addMethod("onlyOneChecked", function(value, element) {
            return $('.correct-answer:checked').length === 1;
        }, "يجب اختيار إجابة صحيحة واحدة فقط");
        $('#addQuestionForm').validate({
            rules: {
                question_type: {
                    required: true,
                },
                question_attachment: {
                    required: true,
                },
                name: {
                    required: true,
                },
                mark: {
                    required: true,
                },

                "is_correct[]": {
                    onlyOneChecked: true
                },

            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages
                $('#submit-button').prop('disabled',
                    true); // Disable submit button to prevent multiple submissions

                var url = $('#addQuestionForm').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        // Handle the response on success
                        if (response.success) {
                            toastr.success(response.message,
                                'نجاح العملية', {
                                    timeOut: 3000
                                });
                            $('#addQuessatioModal').modal('hide');
                            $('#data-table').DataTable().ajax.reload();

                            $('#addQuestionForm')[0].reset();
                        } else {
                            toastr.error(response.message, 'Error', {
                                timeOut: 3000
                            });
                        }
                    },
                    error: function(xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            // Loop through the validation errors and display them with toastr
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                // Show the error messages in the corresponding fields
                                var errorContainer = $('#' + field + '_error');
                                errorContainer.text(messages.join(', '))
                                    .show(); // Join messages if there are multiple
                            });
                        } else {
                            // For other errors, display a general error message
                            toastr.error(
                                '{{ __('messages.An error occurred. Please try again later') }}',
                                'Error', {
                                    timeOut: 3000
                                });
                        }
                    }
                });
            }
        });
        $('#addExcel').validate({
            rules: {


                file: {
                    required: true,
                },



            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages
                $('#submit-button').prop('disabled',
                    true); // Disable submit button to prevent multiple submissions

                var url = $('#addExcel').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        // Handle the response on success
                        if (response.success) {
                            toastr.success(response.message,
                                'نجاح العملية', {
                                    timeOut: 3000
                                });
                            $('#addExcelModal').modal('hide');
                            $('#data-table').DataTable().ajax.reload();
                        } else {
                            toastr.error(response.message, 'Error', {
                                timeOut: 3000
                            });
                        }
                    },
                    error: function(xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            // Loop through the validation errors and display them with toastr
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                // Show the error messages in the corresponding fields
                                var errorContainer = $('#' + field + '_error');
                                errorContainer.text(messages.join(', '))
                                    .show(); // Join messages if there are multiple
                            });
                        } else {
                            // For other errors, display a general error message
                            toastr.error(
                                '{{ __('messages.An error occurred. Please try again later') }}',
                                'Error', {
                                    timeOut: 3000
                                });
                        }
                    }
                });
            }
        });



        // Delete button click
        $(document).on('click', '.delete', function(e) {
            e.preventDefault();
            var name_delete = $(this).data('name_delete');
            var ids = $(this).data('id');
            $('#Delete_id').val(ids);
            $('#Name_Delete').val(name_delete);
            $('#confirmModal').modal('show');
        });
        // Confirm delete action
        $(document).on('click', '.delete_submit', function(e) {
            e.preventDefault();

            var ids = $('#Delete_id').val();
            $('#confirmModal').modal('hide');

            // Perform the AJAX delete request
            $.ajax({
                url: '{{ route('dashboard.contestModels.delete') }}',
                method: 'POST',
                data: {
                    "id": ids,
                    "_token": "{{ csrf_token() }}"
                },
                success: function(response) {
                    if (response.success) {
                        // Show success notification
                        toastr.success(response.message, 'Success', {
                            timeOut: 3000
                        });

                        // Reload the DataTable
                        $('#data-table').DataTable().ajax.reload();
                    } else {
                        // Show error notification
                        toastr.error(response.message, 'Error', {
                            timeOut: 3000
                        });
                    }
                },
                error: function(xhr) {
                    // Hide the spinner and enable the submit button

                    // For other errors, display a general error message
                    toastr.error('هناك خطا ما يرجى المحاولى لاحقا',
                        'فشل العملية', {
                            timeOut: 3000
                        });


                }
            });
        });
        $(document).on('click', '.question_list', function() {
            var contestId = $(this).data('contest_id'); // Get contest ID from data attribute

            $.ajax({
                url: '{{ route('dashboard.contests.questionList') }}', // Endpoint to fetch questions
                method: 'GET',
                data: {
                    contest_id: contestId
                },
                success: function(response) {
                    if (response.success && response.questions.length > 0) {
                        var questionsHtml = '';

                        // Loop through each question
                        $.each(response.questions, function(index, question) {

                            var answersHtml = '';
                            // Loop through each answer for the question and place them in the same row
                            $.each(question.answers, function(index, answer) {
                                // Check if the answer is correct
                                var color = answer.is_correct === 1 ?
                                    'color: green;' : 'color: red;';

                                answersHtml += `
                    <td style="${color}">${answer.answer}</td> <!-- Display the 'answer' field with background color -->
                `;
                            });

                            // Add the question, attachment, and answers in the same row
                            questionsHtml += `
                <tr>
                    <td><img src="${question.attachment}" alt="Attachment" style="max-width: 100px; max-height: 100px;"/></td>

                    ${answersHtml} <!-- Display the answers in the same row -->
                </tr>
            `;
                        });

                        // Update the modal body with the newly generated HTML
                        $('#examTableBody').html(questionsHtml);

                        // Show the modal
                        $('#questionListModal').modal('show');
                    } else {
                        // If no questions found, display a message in the table
                        $('#examTableBody').html(
                            '<tr><td colspan="5">No questions found.</td></tr>');
                        $('#questionListModal').modal('show');
                    }
                },

                error: function(xhr, status, error) {
                    console.error('AJAX Error:', status, error);
                    alert('Error loading questions');
                }
            });
        });





    });
</script>
