{{-- <script src="{{ asset('assets/js/jquery.min.js') }}"></script> --}}
<script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('assets/js/additional-methods.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/localization/messages_ar.js"></script>
<script>
    $(document).ready(function() {


                // Reset form and hide previews when modal is closed
                $('#kt_modal_add_edit').on('hidden.bs.modal', function() {
                    $('.error').text('');
                    $('#my-form').attr('action', "{{ route('dashboard.contestQuestions.store') }}");
                    $('.card-title').text('اضافة اسئلة مسابقات  جديدة');

                    $('#add_edit_image-preview').attr('src', '');
                    $('#add_edit_image-preview').hide();

                    $('#my-form')[0].reset();
                    // $('#add_edit_photo').hide();
                    $('#add_edit_contest_id').val('').trigger('change.select2');


                });


                $('#search_contest_id').on('change', function() {
                    table.draw();
                });
                // DataTable initialization
                var table = $('#data-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('dashboard.contestQuestions.getIndex') }}",
                        data: function(d) {
                            d.search_contest_id = $('#search_contest_id').val();

                        },
                    },
                    columns: [



                        {
                            data: 'name',
                            name: 'name',
                        },
                        {
                            data: 'contests',
                            name: 'contests',
                        },
                        {
                            data: 'actions',
                            name: 'actions',
                            orderable: false,
                            searchable: false
                        }
                    ],
                    order: [
                        [1, 'desc']
                    ]
                });

                // Search filter
                $('[data-kt-data-table-filter="search"]').on('keyup', function() {
                    table.search(this.value).draw();
                });



                // Show modal if needed
                if ($('#show_modal').val()) {
                    $('#kt_modal_add_edit').modal('show');
                }

                // Form validation and AJAX submit


                function previewImage(event, previewSelector) {
                    const output = $(previewSelector);
                    output.attr('src', URL.createObjectURL(event.target.files[0])).show();
                }
                $('#add_edit_photo').on('change', function(event) {
                    previewImage(event, '#add_edit_image-preview');
                });


                $(document).on('click', '.edit', function() {
                    $('modal-title').text('تعديل اسئلة المسابقة ')
                        const id = $(this).data('id');
                        const name = $(this).data('name');
                        const contestId = $(this).data('contest_id');
                        const mark = $(this).data('mark');
                        const contestQuesstionId = $(this).data('contest-question_id');
                        const attachment = $(this).data('attachment');
                        const answers = $(this).data('answers');
                        $('#my-form').attr('action', "{{ route('dashboard.contestQuestions.update') }}");

                        // Populate modal fields
                        $('#add_edit_contest_quesstion_id').val(id);
                        $('#add_edit_name').val(name);
                        $('#add_edit_contest_id').val(contestId).trigger('change');
                        $('#add_edit_mark').val(mark);


                        // If there's an attachment, display the image preview
                        if (attachment) {
                            $('#add_edit_image-preview').attr('src', attachment).show();
                        } else {
                            $('#add_edit_image-preview').hide();
                        }

                        // Populate answers
                        if (answers) {
                            for (const key in answers) {
                                console.log(key);
                                $(`input[name="answers[${key}][answer]"]`).val(answers[key].answer);
                                const isCorrect = answers[key].is_correct == 1; // Convert 1 to true and 0 to false
                                console.log(isCorrect);
                                $(`input[name="answers[${key}][is_correct]"]`).prop('checked', isCorrect);

                                // $(`input[name="answers[${key}][is_correct]"]`).prop('checked', answers[key].is_correct);
                            }
                        }
                        $('#kt_modal_add_edit').modal('show');
                    });

                    // Change event for material selection






                    $.validator.addMethod("onlyOneChecked", function(value, element) {
                        return $('.correct-answer:checked').length === 1;
                    }, "يجب اختيار إجابة صحيحة واحدة فقط");
                    $('#my-form').validate({
                        rules: {
                            question_type: {
                                required: true,
                            },
                            question_attachment: {
                                required: function(){
                                    return $('#add_edit_contest_quesstion_id').val()=='';
                                },
                            },
                            name: {
                                required: true,
                            },
                            mark: {
                                required: true,
                            },

                            "is_correct[]": {
                                onlyOneChecked: true
                            },

                        },
                        submitHandler: function(form) {
                            $('#spinner').show();
                            $('.error').hide(); // Hide previous error messages
                            $('#submit-button').prop('disabled',
                                true); // Disable submit button to prevent multiple submissions

                            var url = $('#my-form').attr('action');
                            $.ajax({
                                url: url,
                                type: 'POST',
                                data: new FormData(form),
                                processData: false,
                                contentType: false,
                                success: function(response) {
                                    // Hide the spinner and enable the submit button
                                    $('#spinner').hide();
                                    $('#submit-button').prop('disabled', false);

                                    // Handle the response on success
                                    if (response.success) {
                                        toastr.success(response.message,
                                            'نجاح العملية', {
                                                timeOut: 3000
                                            });
                                        $('#kt_modal_add_edit').modal('hide');
                                        $('#data-table').DataTable().ajax.reload();

                                        $('#my-form')[0].reset();
                                    } else {
                                        toastr.error(response.message, 'Error', {
                                            timeOut: 3000
                                        });
                                    }
                                },
                                error: function(xhr) {
                                    // Hide the spinner and enable the submit button
                                    $('#spinner').hide();
                                    $('#submit-button').prop('disabled', false);

                                    if (xhr.status === 422) {
                                        // Loop through the validation errors and display them with toastr
                                        var errors = xhr.responseJSON.errors;
                                        $.each(errors, function(field, messages) {
                                            // Show the error messages in the corresponding fields
                                            var errorContainer = $('#' + field +
                                                '_error');
                                            errorContainer.text(messages.join(
                                                    ', '))
                                                .show(); // Join messages if there are multiple
                                        });
                                    } else {
                                        // For other errors, display a general error message
                                        toastr.error(
                                            '{{ __('messages.An error occurred. Please try again later') }}',
                                            'Error', {
                                                timeOut: 3000
                                            });
                                    }
                                }
                            });
                        }
                    });




                    // Delete button click
                    $(document).on('click', '.delete', function(e) {
                        e.preventDefault();
                        var name_delete = $(this).data('name_delete');
                        var ids = $(this).data('id');
                        $('#Delete_id').val(ids);
                        $('#Name_Delete').val(name_delete);
                        $('#confirmModal').modal('show');
                    });
                    // Confirm delete action
                    $(document).on('click', '.delete_submit', function(e) {
                        e.preventDefault();

                        var ids = $('#Delete_id').val();
                        $('#confirmModal').modal('hide');

                        // Perform the AJAX delete request
                        $.ajax({
                            url: '{{ route('dashboard.contestQuestions.delete') }}',
                            method: 'POST',
                            data: {
                                "id": ids,
                                "_token": "{{ csrf_token() }}"
                            },
                            success: function(response) {
                                if (response.success) {
                                    // Show success notification
                                    toastr.success(response.message, 'Success', {
                                        timeOut: 3000
                                    });

                                    // Reload the DataTable
                                    $('#data-table').DataTable().ajax.reload();
                                } else {
                                    // Show error notification
                                    toastr.error(response.message, 'Error', {
                                        timeOut: 3000
                                    });
                                }
                            },
                            error: function(xhr) {
                                // Hide the spinner and enable the submit button

                                // For other errors, display a general error message
                                toastr.error('هناك خطا ما يرجى المحاولى لاحقا',
                                    'فشل العملية', {
                                        timeOut: 3000
                                    });


                            }
                        });
                    });



        $("#upload-form").validate({
            rules: {

                "excel_file": {
                    required: true,
                },
            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages

                $('#submit-button').prop('disabled',
                    true); // Disable submit button to prevent multiple submissions

                var url = $('#upload-form').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        $('#spinner').hide();
                        $('#kt_modal_upload_excel').modal('hide');

                        $('#upload-form')[0].reset();
                        if (response.success) {
                            toastr.success(response.message, 'Success');

                            $('#data-table').DataTable().ajax.reload();

                        } else {


                            if (response.errors) {
                                // Optional: Display validation errors
                                console.log('Validation Errors:', response.errors);
                            }

                            // If the response includes an error file, prompt download
                            if (response.download_url) {

                                // window.open(response.download_url, '_blank');
                                toastr.success(response.message, 'Success');

                                window.location.href = response.download_url;
                            }
                        }

                    },
                    error: function(xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            // Loop through the validation errors and display them with toastr
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                // Show the error messages in the corresponding fields
                                var errorContainer = $('#' + field + '_error');
                                errorContainer.text(messages.join(', '))
                                    .show(); // Join messages if there are multiple
                            });
                        } else {
                            // For other errors, display a general error message
                            toastr.error(
                                '{{ __('messages.An error occurred. Please try again later') }}',
                                'Error', {
                                    timeOut: 3000
                                });
                        }
                    }
                });
            }
        });




                });
</script>
