<div class="modal fade" id="kt_modal_add_edit" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h5 class="modal-title">اضافة مسابقة جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <!-- Modal Body -->
            <form id="my-form" action="{{ route('dashboard.contests.store') }}" method="post"
                enctype="multipart/form-data">


                @csrf
                <div class="modal-body">
                    <!-- Name and Email Fields -->
                    <input type="hidden" id="add_edit_contest_id" name="contest_id"
                        class="form-control form-control-solid">

                    <div class="form-group mb-3 row">
                        <div class="col-lg-6 col-sm-12">
                            <label for="name" class="form-label">
                                الاسم
                                <span class="required"></span>
                            </label>
                            <input type="text" id="add_edit_name" name="name"
                                class="form-control form-control-solid">
                            @error('name')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>


                        <div class="col-lg-6 col-sm-12">
                            <label for="add_edit_class_room_id" class="form-label">

                                الفصل الدراسي
                                <span class="required"></span>
                            </label>


                            <select class="form-select select2-container" data-control="select2" dir="rtl"
                                id="add_edit_level_id" name="level_id">

                                <option value="">اختر</option>
                                @foreach ($levels as $value)
                                    <option value="{{ $value->id }}">{{ $value->name }}
                                    </option>
                                @endforeach
                            </select>

                            @error('class_room_id')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror

                        </div>



                    </div>

                    <div class="form-group mb-3 row">

                        <div class="col-lg-6 col-sm-12">
                            <label for="date" class="form-label">
                                التاريخ
                                <span class="required"></span>
                            </label>
                            <input type="text" value="" id="add_edit_date" name="date"
                                class="date form-control form-control-solid">
                            @error('date')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="col-lg-6 col-sm-12">
                            <label for="add_edit_duration" class="form-label">
                                المدة الزمنية
                                <span class="required"></span>
                            </label>
                            <input type="number" min="1" value="" id="add_edit_duration" name="duration"
                                class="form-control form-control-solid">
                            @error('duration')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>



                    </div>




                    <div class="form-group mb-3 row">
                        <div class="col-lg-6 col-sm-12">
                            <label for="add_edit_start_time" class="form-label">
                                وقت البداية
                                <span class="required"></span>
                            </label>
                            <input type="text" class="form-control form-control-solid time" id="add_edit_start_time"
                                name="start_time" placeholder="Select time" />
                            @error('start_time')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="col-lg-6 col-sm-12">
                            <label for="end_time" class="form-label">
                                وقت الانتهاء
                                <span class="required"></span>
                            </label>
                            <input type="text" value="" id="add_edit_end_time" name="end_time"
                                class="form-control form-control-solid time">
                            @error('end_time')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="form-group mb-3 row">

                        <div class="col-md-6">
                            <label for="photo" class="form-label">صورة الغلاف</label>
                            <input type="file" class="form-control" id="add_edit_photo" name="photo">
                            <div id="photo" class="error"></div>

                            <div class="mb-3">
                                <img id="add_edit_image-preview" src="#" alt="Image Preview"
                                    style="display:none; max-width: 100px;">
                            </div>
                        </div>

                    </div>

                    <div class="form-group mb-3 row">
                        <div class="col-md-6 d-flex align-items-center">
                            <div class="form-check form-check-custom form-check-solid">
                                <input class="form-check-input" type="checkbox" id="add_edit_is_random" value="1" name="is_random">
                                <label class="form-check-label ms-2" for="add_edit_is_random">ترتيب الاسئلة بشكل عشوائي</label>
                            </div>
                        </div>
                    </div>



                </div>

                <!-- Modal Footer -->
                <div class="modal-footer">
                    <!-- Submit Button -->
                    <button type="submit" class="btn btn-primary" form="my-form">
                        <i class="ki ki-submit-duotone fs-2"></i>تاكيد
                    </button>

                    <!-- Cancel Button -->
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                        <i class="ki ki-times-duotone fs-2"></i> الغاء
                    </button>

                    <!-- Spinner (hidden initially) -->
                    <div id="spinner" class="spinner-border text-primary" role="status" style="display:none;">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>

            </form>
        </div>
    </div>
</div>
