@extends('layouts.master')
@section('main_title', 'قائمة المسابقات')
@section('main_page', 'المسابقات')
@section('title', 'المسابقات')

@section('content')

    <div id="kt_app_content_container" class="app-container container-fluid">
        <!--begin::Row-->
        <div class="row g-5 gx-xl-10 mb-5 mb-xl-10">

            <div class="card">
                <!--begin::Card header-->
                <div class="card-header border-0 pt-6">
                    <!--begin::Card title-->
                    <div class="card-title">
                        <!--begin::Search-->
                        <div class="d-flex align-items-center position-relative my-1">
                            <i class="ki-duotone ki-magnifier fs-3 position-absolute ms-5">
                                <span class="path1"></span>
                                <span class="path2"></span>
                            </i>
                            <input type="text" data-kt-data-table-filter="search"
                                class="form-control form-control-solid w-200px ps-12" placeholder="Search" />
                        </div>

                        <div class="d-flex align-items-center position-relative my-1">
                            <select class="form-select ms-2 form-control form-control-solid w-210px ps-12" data-dir="rtl"
                                style="width: 100%" id="search_level_id" data-control="select2" name="search_level_id"
                                data-placeholder="المستويات التعليمية ">
                                <option value="-1" selected>المستويات التعليمية</option>
                                <option value="">المستويات التعليمية</option>

                                @foreach ($levels as $value)
                                    <option value="{{ $value->id }}">{{ $value->name }}</option>
                                @endforeach
                            </select>
                        </div>





                        <!--end::Search-->
                    </div>
                    <!--begin::Card title-->
                    <!--begin::Card toolbar-->
                    <div class="card-toolbar">
                        <!--begin::Toolbar-->
                        <div class="d-flex justify-content-end" data-kt-customer-table-toolbar="base">
                            <!--begin::Filter-->

                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                data-bs-target="#kt_modal_add_edit">اضافة مسابقة جديدة</button>
                            <!--end::Add customer-->
                        </div>
                        <!--end::Toolbar-->
                        <!--begin::Group actions-->
                        <div class="d-flex justify-content-end align-items-center d-none"
                            data-kt-customer-table-toolbar="selected">
                            <div class="fw-bold me-5">
                                <span class="me-2" data-kt-customer-table-select="selected_count"></span>Selected
                            </div>
                            <button type="button" class="btn btn-danger"
                                data-kt-customer-table-select="delete_selected">Delete Selected</button>
                        </div>
                        <!--end::Group actions-->
                    </div>
                    <!--end::Card toolbar-->
                </div>
                <!--end::Card header-->
                <!--begin::Card body-->
                <div class="card-body pt-0">
                    <!--begin::Table-->
                    <table class="table align-middle table-row-dashed fs-6 gy-5" id="data-table">



                        <thead>
                            <tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase gs-0" style="width: 100%">

                            <tr class="fw-semibold fs-6 text-gray-800">
                                <th style="20%">الاسم</th>
                                <th style="10%">المستوى التعليمي</th>
                                <th style="10%">التاريخ</th>
                                <th style="10%">وقت البداية</th>
                                <th style="10%">وقت الانتهاء</th>

                                <th style="10%">عدد الاسئلة</th>
                                <th style="30%"></th>
                            </tr>

                        </thead>
                        <tbody>

                        </tbody>

                    </table>
                </div>
            </div>

        </div>
    </div>


    <input type="hidden" name="show_modal" id="show_modal" value="{{ $modal }}">

    @include('dashboard.contests.Model.create_update')


    <div class="modal fade" id="attachmentModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel"
        aria-modal="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="add_attachment_modal-title" id="modalLabel">اضافة مرفقات</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="save-attachments" action="{{ route('dashboard.contests.addAttachment') }}" method="post">

                        @csrf
                        <div class="form-group row">
                            <div class="form-group mb-3 row">
                                <div class="col-lg-6 col-sm-12">
                                    <label for="add_edit_title" class="form-label">
                                        الاسم
                                        <span class="required"></span>
                                    </label>
                                    <input type="text" id="add_edit_title" name="title"
                                        class="form-control form-control-solid">
                                    @error('title')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <input type="hidden" name="contest_id" id="add_edit_attachment_contest_id">

                                <div class="col-lg-6 col-sm-12">
                                    <label for="attachment" class="form-label">المرفق <span class="required"></span></label>

                                    <input type="file" id="attachment_book" name="attachment_book"
                                        class="form-control form-control-solid" accept="application/pdf">

                                    @error('attachment')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror


                                </div>
                            </div>
                        </div>
                </div>

                <!-- Submit Button -->
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" form="save-attachments">
                        <i class="ki ki-submit-duotone fs-2"></i>تاكيد
                    </button>
                    <!-- Cancel Button -->
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                        <i class="ki ki-times-duotone fs-2"></i> الغاء
                    </button>

                    <div id="spinner" class="spinner-border text-primary" role="status" style="display:none;">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="allAttachmentModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel"
        aria-modal="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="attachment_modal-title" id="modalLabel">عرض المرفقات</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <table class="table align-middle table-row-dashed fs-6 gy-5">


                        <thead>
                            <tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase gs-0">

                            <tr class="fw-semibold fs-6 text-gray-800">

                                <th>عنوان مرفق</th>
                                <th>المرفق</th>
                                <th></th>

                            </tr>

                        </thead>
                        <tbody id="attachmentTableBody">

                        </tbody>

                        <!-- Submit Button -->
                    </table>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="questionListModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalLabel">قائمة الاسئلة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <table class="table align-middle table-row-dashed fs-6 gy-5">
                        <thead>
                            <tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase gs-0">
                                <th></th>
                                <th>A</th>
                                <th>B</th>
                                <th>C</th>
                                <th>D</th>
                                <th>E</th>

                            </tr>
                        </thead>
                        <tbody id="examTableBody">
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="addQuessatioModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel"
        aria-modal="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalLabel">إضافة اسئلة </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="addQuestionForm" action="{{ route('dashboard.contests.addquestion') }}" method="POST">
                        @csrf

                        <div class="form-group row">
                            <input type="hidden" class="form-control mb-2 mb-md-0" id="add_question_contest_id"
                                name="contest_id" />

                            <div class="col-6">
                                <label class="form-label">اسم السؤال</label>
                                <input type="text" class="form-control mb-2 mb-md-0" name="name" />


                            </div>

                            <div class="col-6">
                                <label class="form-label"> مرفق:</label>
                                <input type="file" accept="image/*" class="form-control mb-2 mb-md-0"
                                    name="question_attachment" />
                            </div>
                        </div>

                        <!-- Repeated Chapter Section -->
                        <div class="question-item mb-3">
                            <div class="form-group row">
                                <div class="col-6">
                                    <label class="form-label">العلامة</label>
                                    <input type="number" min="0" class="form-control mb-2 mb-md-0"
                                        name="mark" />
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-6">
                                    <label class="form-label">الاجابة:</label>
                                    <input type="text" class="form-control mb-2 mb-md-0" name="answers[A][answer]"
                                        value="A" />
                                </div>
                                <div class="col-3">
                                    <label for="status">الاجابة الصحيحة</label>
                                    <br>
                                    <div class="form-check form-switch mt-5">
                                        <input class="form-check-input correct-answer" type="checkbox"
                                            name="answers[A][is_correct]" />
                                    </div>
                                </div>
                            </div>


                            <div class="form-group row">
                                <div class="col-6">
                                    <label class="form-label">الاجابة:</label>
                                    <input type="text" class="form-control mb-2 mb-md-0" name="answers[B][answer]"
                                        value="B" />
                                </div>
                                <div class="col-3">
                                    <label for="status">الاجابة الصحيحة</label>
                                    <br>
                                    <div class="form-check form-switch mt-5">
                                        <input class="form-check-input correct-answer" type="checkbox"
                                            name="answers[B][is_correct]" />
                                    </div>
                                </div>
                            </div>

                            <div class="form-group row">
                                <div class="col-6">
                                    <label class="form-label">الاجابة:</label>
                                    <input type="text" class="form-control mb-2 mb-md-0" name="answers[C][answer]"
                                        value="C" />
                                </div>
                                <div class="col-3">
                                    <label for="status">الاجابة الصحيحة</label>
                                    <br>
                                    <div class="form-check form-switch mt-5">
                                        <input class="form-check-input correct-answer" type="checkbox"
                                            name="answers[C][is_correct]" />
                                    </div>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-6">
                                    <label class="form-label">الاجابة:</label>
                                    <input type="text" class="form-control mb-2 mb-md-0" name="answers[D][answer]"
                                        value="D" />
                                </div>
                                <div class="col-3">
                                    <label for="status">الاجابة الصحيحة</label>
                                    <br>
                                    <div class="form-check form-switch mt-5">
                                        <input class="form-check-input correct-answer" type="checkbox"
                                            name="answers[D][is_correct]" />
                                    </div>
                                </div>
                            </div>



                            <div class="form-group row">
                                <div class="col-6">
                                    <label class="form-label">الاجابة:</label>
                                    <input type="text" class="form-control mb-2 mb-md-0" name="answers[E][answer]"
                                        value="E" />
                                </div>
                                <div class="col-3">
                                    <label for="status">الاجابة الصحيحة</label>
                                    <br>
                                    <div class="form-check form-switch mt-5">
                                        <input class="form-check-input correct-answer" type="checkbox"
                                            name="answers[E][is_correct]" />
                                    </div>
                                </div>
                            </div>


                        </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" form="addQuestionForm">تأكيد <i
                            class="fa fa-paper-plane"></i></button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">الغاء</button>
                    <div id="spinner" class="spinner-border text-primary" role="status" style="display:none;">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
                </form>
            </div>

        </div>
    </div>


    <div class="modal fade" id="DamgeQuestion" tabindex="-1" role="dialog" aria-labelledby="modalLabel"
        aria-modal="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="damage_question_modal-title" id="modalLabel">اضافة صورة توضيحية للاسئلة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="save-photo" action="{{ route('dashboard.contests.addPhoto') }}" method="post">

                        @csrf
                        <div class="form-group row">
                            <div class="form-group mb-3 row">
                                <div class="col-lg-6 col-sm-12">
                                    <label for="add_edit_question_id" class="form-label">
                                        الاسئلة
                                        <span class="required"></span>
                                    </label>
                                    <select class="form-select ms-2 form-control form-control-solid w-210px ps-12"
                                        data-dir="rtl" style="width: 100%" id="add_edit_question_id"
                                        data-control="select2" name="question_id[]" multiple
                                        data-placeholder="الاسئلة المختارة">
                                        <option value="">الاسئلة المختارة</option>


                                    </select>
                                </div>

                                <input type="hidden" name="contest_id" id="add_edit_question_contest_id">

                                <div class="col-lg-6 col-sm-12">
                                    <label for="attachment" class="form-label">المرفق <span
                                            class="required"></span></label>

                                    <input type="file" id="attachment_photo" name="attachment_photo"
                                        class="form-control form-control-solid" accept="image/jpg,png,jpeg,svg">

                                    @error('attachment')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror


                                </div>
                            </div>
                        </div>
                </div>

                <!-- Submit Button -->
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" form="save-photo">
                        <i class="ki ki-submit-duotone fs-2"></i>تاكيد
                    </button>

                    <!-- Cancel Button -->
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                        <i class="ki ki-times-duotone fs-2"></i> الغاء
                    </button>
                    <div id="spinner" class="spinner-border text-primary" role="status" style="display:none;">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
                </form>
            </div>
        </div>
    </div>







    <div class="modal fade" id="addExcelModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel"
        aria-modal="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalLabel">تصدير اكسل </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="addExcel" action="{{ route('dashboard.contests.uploadExcel') }}" method="POST">
                        @csrf

                        <input type="hidden" name="contest_id" id="excel_upload_contest_id">

                        <div class="form-group mb-3 text-center">
                            <label class="form-label">تنزيل نموذج الاكسل</label>
                            <a href="{{ asset('storage/uploads/questions.xlsx') }}" target="_blank"
                                style="color: #D39494">
                                <svg fill="#000000" width="50px" height="50px" viewBox="0 0 16 16"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M7 5.222V0h2v5.193l1.107-1.107L11.52 5.5 7.986 9.036 4.45 5.5l1.414-1.414L7 5.222zM16 11v5H0v-5h2v3h12v-3h2z"
                                        fill-rule="evenodd" />
                                </svg>
                            </a>
                        </div>
                        <div class="form-group mb-3">
                            <label for="excelFile" class="form-label">اختر ملف Excel</label>
                            <input type="file" id="excelFile" name="file" class="form-control">
                            @error('file')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary btn-sm"><i
                                    class="fa fa-paper-plane"></i>رفع</button>
                            <button class=" btn btn-defuat btn-sm" data-bs-dismiss="modal"
                                aria-label="Close">الغاء</button>

                                <div id="spinner" class="spinner-border text-primary" role="status" style="display:none;">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>

    @include('Shared.delete')
@endsection

@section('scripts')
    @include('dashboard.contests.js.js')
@endsection
