{{-- <script src="{{ asset('assets/js/jquery.min.js') }}"></script> --}}
<script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('assets/js/additional-methods.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/localization/messages_ar.js"></script>
<script>
    $(document).ready(function() {
        function previewImage(event, previewSelector) {
            const output = $(previewSelector);
            output.attr('src', URL.createObjectURL(event.target.files[0])).show();
        }
        $('#add_edit_photo').on('change', function(event) {
            previewImage(event, '#add_edit_image-preview');
        });
        $(".date").flatpickr();
        flatpickr(".time", {
    enableTime: true, // Enable time picker
    noCalendar: true, // Disable calendar view
    dateFormat: "H:i", // 24-hour format
    time_24hr: true // Use 24-hour format
});


        // Reset form and hide previews when modal is closed
        $('#kt_modal_add_edit').on('hidden.bs.modal', function() {
            $('.error').text('');
            $('#my-form').attr('action', "{{ route('dashboard.contests.store') }}");
            $('.card-title').text('اضافة مسابقة جديدة');

            $('#my-form')[0].reset();
            // $('#add_edit_photo').hide();
            $('#add_edit_class_room_id').val('').trigger('change.select2');


        });


        $('#search_level_id').on('change', function() {
            table.draw();
        });
        // DataTable initialization
        var table = $('#data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('dashboard.contests.getIndex') }}",
                data: function(d) {
                    d.search_level_id = $('#search_level_id').val();

                },
            },
            columns: [


                {
                    data: 'name',
                    name: 'name'
                },

                {
                    data: 'levels',
                    name: 'levels',
                },
                {
                    data: 'date',
                    name: 'date',
                },
                {
                    data: 'start_time',
                    name: 'start_time',
                },

                {
                    data: 'end_time',
                    name: 'end_time',
                },

                {
                    data: 'question_count',
                    name: 'question_count',
                },


                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
            ],
            order: [
                [1, 'desc']
            ]
        });

        // Search filter
        $('[data-kt-data-table-filter="search"]').on('keyup', function() {
            table.search(this.value).draw();
        });



        // Show modal if needed
        if ($('#show_modal').val()) {
            $('#kt_modal_add_edit').modal('show');
        }

        // Form validation and AJAX submit
        $('#my-form').validate({
            rules: {
                name: {
                    required: true,
                },

                date: {
                    required: true,
                },
                level_id: {
                    required: true,

                },
                duration:{
                    required:true,

                },

                start_time: {
                    required: true,

                },
                end_time: {
                    required: true,

                },
                question_count: {
                    required: true,

                }


            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages
                $('#submit-button').prop('disabled',
                    true); // Disable submit button to prevent multiple submissions

                var url = $('#my-form').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        // Handle the response on success
                        if (response.success) {
                            toastr.success(response.message,
                                'نجاح العملية', {
                                    timeOut: 3000
                                });
                            $('#kt_modal_add_edit').modal('hide');
                            $('#data-table').DataTable().ajax.reload();
                        } else {
                            toastr.error(response.message, 'Error', {
                                timeOut: 3000
                            });
                        }
                    },
                    error: function(xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            // Loop through the validation errors and display them with toastr
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                // Show the error messages in the corresponding fields
                                var errorContainer = $('#' + field + '_error');
                                errorContainer.text(messages.join(', '))
                                    .show(); // Join messages if there are multiple
                            });
                        } else {
                            // For other errors, display a general error message
                            toastr.error(
                                '{{ __('messages.An error occurred. Please try again later') }}',
                                'Error', {
                                    timeOut: 3000
                                });
                        }
                    }
                });
            }
        });



        $(document).on('click', '.edit', function() {
            var contestId = $(this).data('contest_id');
            var name = $(this).data('name');
            var date = $(this).data('date');
            var start_time = $(this).data('start_time');
            var end_time = $(this).data('end_time');
            var questionCount = $(this).data('question_count');
            var duration = $(this).data('duration');

            var is_random=$(this).data('is_random');
            var photo = $(this).data('photo');
            $('#add_edit_photo').attr('src', photo).show();
            const imagePreview = $('#add_edit_image-preview');
            imagePreview.toggle($(this).data('photo')).attr('src', $(this).data('photo'));
            var levelId = $(this).data('level_id');
            $('#add_edit_level_id').val(levelId).trigger('change.select2');
            $('#my-form').attr('action', "{{ route('dashboard.contests.update') }}");
            $('#add_edit_name').val(name);
            $('#add_edit_contest_id').val(contestId);
            $('#add_edit_date').val(date);
            $('#add_edit_start_time').val(start_time);
            $('#add_edit_end_time').val(end_time);
            $('#add_edit_duration').val(duration);

            $('#add_edit_is_random').prop('checked', is_random === 1);

            $('#add_edit_question_count').val(questionCount);
            $('#kt_modal_add_edit').modal('show');
        });

        // Change event for material selection



        $(document).on('click', '.upload_excel', function() {
            $('#addExcelModal').modal('show');
            var contest_id = $(this).data('contest_id');
            $('#excel_upload_contest_id').val(contest_id);
        });

        $(document).on('click', '.add_question', function() {
            var contest_id = $(this).data('contest_id');
            $('#add_question_contest_id').val(contest_id);
            $('#addQuessatioModal').modal('show');
        });


        $.validator.addMethod("onlyOneChecked", function(value, element) {
            return $('.correct-answer:checked').length === 1;
        }, "يجب اختيار إجابة صحيحة واحدة فقط");
        $('#addQuestionForm').validate({
            rules: {
                question_type: {
                    required: true,
                },
                question_attachment: {
                    required: true,
                },
                name: {
                    required: true,
                },
                mark: {
                    required: true,
                },

                "is_correct[]": {
                    onlyOneChecked: true
                },

            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages
                $('#submit-button').prop('disabled',
                    true); // Disable submit button to prevent multiple submissions

                var url = $('#addQuestionForm').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        // Handle the response on success
                        if (response.success) {
                            toastr.success(response.message,
                                'نجاح العملية', {
                                    timeOut: 3000
                                });
                            $('#addQuessatioModal').modal('hide');
                            $('#data-table').DataTable().ajax.reload();

                            $('#addQuestionForm')[0].reset();
                        } else {
                            toastr.error(response.message, 'Error', {
                                timeOut: 3000
                            });
                        }
                    },
                    error: function(xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            // Loop through the validation errors and display them with toastr
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                // Show the error messages in the corresponding fields
                                var errorContainer = $('#' + field + '_error');
                                errorContainer.text(messages.join(', '))
                                    .show(); // Join messages if there are multiple
                            });
                        } else {
                            // For other errors, display a general error message
                            toastr.error(
                                '{{ __('messages.An error occurred. Please try again later') }}',
                                'Error', {
                                    timeOut: 3000
                                });
                        }
                    }
                });
            }
        });
        $('#addExcel').validate({
            rules: {


                file: {
                    required: true,
                },



            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages
                $('#submit-button').prop('disabled',
                    true); // Disable submit button to prevent multiple submissions

                var url = $('#addExcel').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        // Handle the response on success
                        if (response.success) {
                            toastr.success(response.message,
                                'نجاح العملية', {
                                    timeOut: 3000
                                });
                            $('#addExcelModal').modal('hide');
                            $('#data-table').DataTable().ajax.reload();
                        } else {
                            toastr.error(response.message, 'Error', {
                                timeOut: 3000
                            });
                        }
                    },
                    error: function(xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            // Loop through the validation errors and display them with toastr
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                // Show the error messages in the corresponding fields
                                var errorContainer = $('#' + field + '_error');
                                errorContainer.text(messages.join(', '))
                                    .show(); // Join messages if there are multiple
                            });
                        } else {
                            // For other errors, display a general error message
                            toastr.error(
                                '{{ __('messages.An error occurred. Please try again later') }}',
                                'Error', {
                                    timeOut: 3000
                                });
                        }
                    }
                });
            }
        });



        // Delete button click
        $(document).on('click', '.delete', function(e) {
            e.preventDefault();
            var name_delete = $(this).data('name_delete');
            var ids = $(this).data('id');
            $('#Delete_id').val(ids);
            $('#Name_Delete').val(name_delete);
            $('#confirmModal').modal('show');
        });
        // Confirm delete action
        $(document).on('click', '.delete_submit', function(e) {
            e.preventDefault();

            var ids = $('#Delete_id').val();
            $('#confirmModal').modal('hide');

            // Perform the AJAX delete request
            $.ajax({
                url: '{{ route('dashboard.contests.delete') }}',
                method: 'POST',
                data: {
                    "id": ids,
                    "_token": "{{ csrf_token() }}"
                },
                success: function(response) {
                    if (response.success) {
                        // Show success notification
                        toastr.success(response.message, 'Success', {
                            timeOut: 3000
                        });

                        // Reload the DataTable
                        $('#data-table').DataTable().ajax.reload();
                    } else {
                        // Show error notification
                        toastr.error(response.message, 'Error', {
                            timeOut: 3000
                        });
                    }
                },
                error: function(xhr) {
                    // Hide the spinner and enable the submit button

                    // For other errors, display a general error message
                    toastr.error('هناك خطا ما يرجى المحاولى لاحقا',
                        'فشل العملية', {
                            timeOut: 3000
                        });


                }
            });
        });

        $(document).on('click', '.question_list', function() {
            var contestId = $(this).data('contest_id'); // Get contest ID from data attribute

            $.ajax({
                url: '{{ route('dashboard.contests.questionList') }}', // Endpoint to fetch questions
                method: 'GET',
                data: {
                    contest_id: contestId
                },
                success: function(response) {
                    if (response.success && response.questions.length > 0) {
                        var questionsHtml = '';

                        // Loop through each question
                        $.each(response.questions, function(index, question) {

                            var answersHtml ='';
                            // Loop through each answer for the question and place them in the same row
                            $.each(question.answers, function(index, answer) {
                // Check if the answer is correct
                var color = answer.is_correct === 1 ? 'color: green;' : 'color: red;';

                answersHtml += `
                    <td style="${color}">${answer.answer}</td> <!-- Display the 'answer' field with background color -->
                `;
            });

                            // Add the question, attachment, and answers in the same row
                            questionsHtml += `
                <tr>
                    <td><img src="${question.attachment}" alt="Attachment" style="max-width: 100px; max-height: 100px;"/></td>

                    ${answersHtml} <!-- Display the answers in the same row -->
                </tr>
            `;
                        });

                        // Update the modal body with the newly generated HTML
                        $('#examTableBody').html(questionsHtml);

                        // Show the modal
                        $('#questionListModal').modal('show');
                    } else {
                        // If no questions found, display a message in the table
                        $('#examTableBody').html(
                            '<tr><td colspan="5">No questions found.</td></tr>');
                        $('#questionListModal').modal('show');
                    }
                },

                error: function(xhr, status, error) {
                    console.error('AJAX Error:', status, error);
                    alert('Error loading questions');
                }
            });
        });




        $(document).on('click', '.add_attachment', function() {
            var contest_id = $(this).data('contest_id');

            $('#add_edit_attachment_contest_id').val(contest_id);
            $('#attachmentModal').modal('show');
        });


        $(document).on('click', '.all_attachment', function() {
            var contest_id = $(this).data('contest_id');
            $('#allAttachmentModal').modal('show');


            $('#attachmentTableBody').empty();

            // Fetch attachments using AJAX
            $.ajax({
                url: "{{ route('dashboard.contests.getAttachments') }}", // Adjust this route to your backend endpoint
                type: "GET",
                data: {
                    contest_id: contest_id
                },
                success: function(response) {
                    // Populate the table with attachments
                    if (response.attachments && response.attachments.length > 0) {
                        response.attachments.forEach(function(attachment) {
                            var row = `<tr>
                                <td>${attachment.title}</td>

                    <td><a href="${'storage/'+attachment.pdf_url}" target="_blank">Download</a></td>
                </tr>`;
                            $('#attachmentTableBody').append(row);
                        });
                    } else {
                        $('#attachmentTableBody').append(
                            '<tr><td colspan="2">لا توجد مرفقات</td></tr>');
                    }
                },
                error: function() {
                    $('#attachmentTableBody').append(
                        '<tr><td colspan="2">حدث خطأ في جلب المرفقات</td></tr>');
                }
            });
        });

        $('#save-photo').validate({
            rules: {

                "question_id[]": {
                    required: true,
                },
                attachment_photo: {
                    required: true,
                },
            },
            messages: {
                question_id: {
                    required: "الرجاء تحديد الاسئلة."
                },
                attachment_photo: {
                    required: "الرجاء اختيار ملف.",
                },
            },
            errorPlacement: function(error, element) {
                error.addClass('text-danger');
                error.insertAfter(element);
            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages
                $('#submit-button').prop('disabled',
                    true); // Disable submit button to prevent multiple submissions

                var url = $('save-photo').attr('action');
                $.ajax({
                    url: "{{ route('dashboard.contests.addPhoto') }}",
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        // Handle the response on success
                        if (response.success) {
                            toastr.success(response.message,
                                'نجاح العملية', {
                                    timeOut: 3000
                                });
                            $('#DamgeQuestion').modal('hide');
                            $('#data-table').DataTable().ajax.reload();
                        } else {
                            toastr.error(response.message, 'Error', {
                                timeOut: 3000
                            });
                        }
                    },
                    error: function(xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            // Loop through the validation errors and display them with toastr
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                // Show the error messages in the corresponding fields
                                var errorContainer = $('#' + field + '_error');
                                errorContainer.text(messages.join(', '))
                                    .show(); // Join messages if there are multiple
                            });
                        } else {
                            // For other errors, display a general error message
                            toastr.error(
                                '{{ __('messages.An error occurred. Please try again later') }}',
                                'Error', {
                                    timeOut: 3000
                                });
                        }
                    }
                });
            }
        });

        $('#save-attachments').validate({
            rules: {

                name: {
                    required: true,
                },
                attachment_book: {
                    required: true,
                    extension: "pdf"
                }
            },
            messages: {
                attachment_title: {
                    required: "الرجاء اختيار عنوان."
                },
                attachment_book: {
                    required: "الرجاء اختيار ملف.",
                    extension: "الملف يجب أن يكون من النوع: pdf, doc, docx, jpg, jpeg, png."
                },
            },
            errorPlacement: function(error, element) {
                error.addClass('text-danger');
                error.insertAfter(element);
            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages
                $('#submit-button').prop('disabled',
                    true); // Disable submit button to prevent multiple submissions

                var url = $('save-attachments').attr('action');
                $.ajax({
                    url: "{{ route('dashboard.contests.addAttachment') }}",
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);
$('#save-attachments')[0].reset();
                        // Handle the response on success
                        if (response.success) {
                            toastr.success(response.message,
                                'نجاح العملية', {
                                    timeOut: 3000
                                });
                            $('#attachmentModal').modal('hide');
                            $('#data-table').DataTable().ajax.reload();
                        } else {
                            toastr.error(response.message, 'Error', {
                                timeOut: 3000
                            });
                        }
                    },
                    error: function(xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            // Loop through the validation errors and display them with toastr
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                // Show the error messages in the corresponding fields
                                var errorContainer = $('#' + field + '_error');
                                errorContainer.text(messages.join(', '))
                                    .show(); // Join messages if there are multiple
                            });
                        } else {
                            // For other errors, display a general error message
                            toastr.error(
                                '{{ __('messages.An error occurred. Please try again later') }}',
                                'Error', {
                                    timeOut: 3000
                                });
                        }
                    }
                });
            }
        });

    });


    $(document).ready(function () {
    // When the button is clicked
    $(document).on('click', '.add_image', function() {

        // Get contest_id from the clicked button's data
        var contestId = $(this).data('contest_id');

        // Set contest_id to the hidden input field
        $('#add_edit_question_contest_id').val(contestId);

        // Fetch questions related to this contest_id
        $.ajax({
            url: '{{route('dashboard.contests.getQuestions')}}', // Define this route in your Laravel application
            method: 'GET',
            data: { contest_id: contestId },
            success: function(response) {
                // Clear previous options in the select dropdown
                $('#add_edit_question_id').empty();

                // Add a default option
                $('#add_edit_question_id').append('<option value="">الاسئلة المختارة</option>');

                // Loop through the questions and add them to the dropdown
                response.questions.forEach(function(question) {
                    $('#add_edit_question_id').append('<option value="' + question.id + '">' + question.name + '</option>');
                });

                // Show the modal
                $('#DamgeQuestion').modal('show');
            },
            error: function() {
                alert('Error fetching questions');
            }
        });
    });
});



</script>
