{{-- <script src="{{ asset('assets/js/jquery.min.js') }}"></script> --}}
<script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('assets/js/additional-methods.min.js') }}"></script>
@if (app()->getLocale() === 'ar')
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/localization/messages_ar.js"></script>
@endif
<script>
    $(document).ready(function() {
        // Reset form and hide previews when modal is closed
        $('#kt_modal_add_edit').on('hidden.bs.modal', function() {
            $('.error').text('');
            $('.modal-title').text('اضافة بيانات المنظقة التعليمية');
            $('.modal-title').text('اضافة بيانات المنظقة التعليمية');
            $('#add_edit_governorate_id').val('').trigger('change.select2');
            const form = $('#my-form'); // The form you want to set the action for
            form.attr('action', "{{ route('dashboard.educationAreaes.store') }}");

            $('#my-form')[0].reset();
        });


        $('#search_governorate_id').on('change', function() {
            table.draw();
        });
        // DataTable initialization
        var table = $('#data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('dashboard.educationAreaes.getIndex') }}",
                data: function(d) {
                    d.search_governorate_id = $('#search_governorate_id').val();
                },
            },
            columns: [


                {
                    data: 'name',
                    name: 'name'
                },

                {
                    data: 'governorates',
                    name: 'governorates',
                },

                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
            ],
            order: [
                [1, 'desc']
            ]
        });

        // Search filter
        $('[data-kt-data-table-filter="search"]').on('keyup', function() {
            table.search(this.value).draw();
        });



        // Show modal if needed
        if ($('#show_modal').val()) {
            $('#kt_modal_add_edit').modal('show');
        }

        // Form validation and AJAX submit
        $('#my-form').validate({
            rules: {
                name: {
                    required: true,
                },

                governorate_id: {
                    required: true,

                },

            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages
                $('#submit-button').prop('disabled',true); // Disable submit button to prevent multiple submissions

                var url = $('#my-form').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        // Handle the response on success
                        if (response.success) {
                            toastr.success(response.message,
                                'نجاح العملية', {
                                    timeOut: 3000
                                });
                            $('#kt_modal_add_edit').modal('hide');
                            $('#data-table').DataTable().ajax.reload();
                        } else {
                            toastr.error(response.message, 'Error', {
                                timeOut: 3000
                            });
                        }
                    },
                    error: function(xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            // Loop through the validation errors and display them with toastr
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                // Show the error messages in the corresponding fields
                                var errorContainer = $('#' + field + '_error');
                                errorContainer.text(messages.join(', '))
                                    .show(); // Join messages if there are multiple
                            });
                        } else {
                            // For other errors, display a general error message
                            toastr.error(
                                '{{ __('messages.An error occurred. Please try again later') }}',
                                'Error', {
                                    timeOut: 3000
                                });
                        }
                    }
                });
            }
        });


        // Handle modal view and edit actions
        $(document).on('click', '.view, .edit', function() {
            const action = $(this).hasClass('view') ? 'view' : 'add_edit';
            const title = $(this).hasClass('view') ? 'عرض بيانات المنطقة التعليمية' :
                'تعديل بيانات المنظقة التعليمية';


            const form = $('#my-form'); // The form you want to set the action for


            // Set the action attribute of the form
            form.attr('action', "{{ route('dashboard.educationAreaes.update') }}");

            const fields = [
                'education_area_id',
                 'name',
                'governorate_id'
            ];

            fields.forEach(field => {

                $('#' + action + '_' + field).val($(this).data(field));


            });
            const governorateId = $(this).data('governorate_id');
            if (governorateId) {
                $('#'+action+'_governorate_id').val(governorateId).trigger('change.select2');
            }




            $('.modal-title').text(title)
            $('#kt_modal_' + action).modal('show');
        });

        // Image preview functions


        // Bind preview functions to file input events

    });



    // Delete button click
    $(document).on('click', '.delete', function(e) {
        e.preventDefault();
        var name_delete = $(this).data('name_delete');
        var ids = $(this).data('id');
        $('#Delete_id').val(ids);
        $('#Name_Delete').val(name_delete);
        $('#confirmModal').modal('show');
    });
    // Confirm delete action
    $(document).on('click', '.delete_submit', function(e) {
        e.preventDefault();

        var ids = $('#Delete_id').val();
        $('#confirmModal').modal('hide');

        // Perform the AJAX delete request
        $.ajax({
            url: '{{ route('dashboard.educationAreaes.delete') }}',
            method: 'POST',
            data: {
                "id": ids,
                "_token": "{{ csrf_token() }}"
            },
            success: function(response) {
                if (response.success) {
                    // Show success notification
                    toastr.success(response.message, 'Success', {
                        timeOut: 3000
                    });

                    // Reload the DataTable
                    $('#data-table').DataTable().ajax.reload();
                } else {
                    // Show error notification
                    toastr.error(response.message, 'Error', {
                        timeOut: 3000
                    });
                }
            },
            error: function(xhr) {
                // Hide the spinner and enable the submit button

                // For other errors, display a general error message
                toastr.error('هناك خطا ما يرجى المحاولى لاحقا',
                    'فشل العملية', {
                        timeOut: 3000
                    });


            }
        });
    });


    function toggleActive(element) {
        var carId = $(element).data('id');
        var isActive = $(element).prop('checked') ? 1 : 0;

        $.ajax({
            url: '{{ route('dashboard.educationAreaes.updateStatus') }}', // Laravel route for toggling the status
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                car_id: carId,
                is_active: isActive
            },
            success: function(response) {

                // Handle the response on success
                if (response.success) {
                    toastr.success(response.message, 'نجاح العملية', {
                        timeOut: 3000
                    });


                } else {
                    toastr.error(response.message, 'فشل العملية', {
                        timeOut: 3000
                    });

                }
            },
            error: function(xhr) {
                // Hide the spinner and enable the submit button

                // For other errors, display a general error message
                toastr.error('هناك خطا ما يرجى المحاولى لاحقا',
                    'فشل العملية', {
                        timeOut: 3000
                    });


            }

        });
    }
</script>
