<div class="modal fade" id="kt_modal_add_edit" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h5 class="modal-title">اضافة امتحان جديد</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <!-- Modal Body -->
            <form id="my-form" action="{{ route('dashboard.exams.store') }}" method="post"
                enctype="multipart/form-data">


                @csrf
                <div class="modal-body">
                    <!-- Name and Email Fields -->
                    <input type="hidden" id="add_edit_exam_id" name="exam_id"  class="form-control form-control-solid" >

                    <div class="form-group mb-3 row">
                        <div class="col-lg-12 col-sm-12">
                            <label for="name" class="form-label">
                                الاسم
                                <span class="required"></span>
                            </label>
                            <input type="text" id="add_edit_name" name="name" class="form-control form-control-solid" >
                            @error('name')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                    </div>

                    <div class="form-group mb-3 row">
                        <div class="col-lg-6 col-sm-12">
                            <label for="add_edit_class_room_id" class="form-label">

                                الفصل الدراسي
                                <span class="required"></span>
                            </label>


                            <select class="form-select select2-container" data-control="select2" dir="rtl"
                                id="add_edit_class_room_id" name="class_room_id">

                                <option value="">اختر</option>
                                @foreach ($classRooms as $value)
                                    <option value="{{ $value->id }}">{{ $value->name }}
                                    </option>
                                @endforeach
                            </select>

                            @error('class_room_id')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror

                        </div>

                        <div class="col-lg-6 col-sm-12">
                            <label for="add_edit_material_id" class="form-label">

                                المادة الدراسية
                                <span class="required"></span>
                            </label>
                            <select class="form-select select2-container" data-control="select2"  dir="rtl"
                              id="add_edit_material_id" name="material_id"
                                >

                                <option value="">اختر</option>

                            </select>

                            @error('material_id')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror

                        </div>

                    </div>

                    <div class="form-group mb-3 row">
                        <div class="col-lg-6 col-sm-12">
                            <label for="question_count" class="form-label">
                                عدد الاسئلة
                                <span class="required"></span>
                            </label>
                            <input type="number" min="1" id="add_edit_question_count" name="question_count" class="form-control form-control-solid" >
                            @error('question_count')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="col-lg-6 col-sm-12">
                            <label for="exam_time" class="form-label">
                                وقت الامتحان
                                <span class="required"></span>
                            </label>
                            <input type="number" min="1" value="" id="add_edit_exam_time" name="exam_time" class="form-control form-control-solid" >
                            @error('exam_time')
                            <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                    </div>


            <div class="form-group mb-3 row">
                        <label class="form-label">الفصول المادة الدراسية <span class="required"></span></label>

                        <div id="chapter-container"></div>
                        @error('chapterIds')
                        <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>





                </div>

                <!-- Modal Footer -->
                <div class="modal-footer">
                    <!-- Submit Button -->
                    <button type="submit" class="btn btn-primary" form="my-form">
                        <i class="ki ki-submit-duotone fs-2"></i>تاكيد
                    </button>

                    <!-- Cancel Button -->
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                        <i class="ki ki-times-duotone fs-2"></i> الغاء
                    </button>

                    <!-- Spinner (hidden initially) -->
                    <div id="spinner" class="spinner-border text-primary" role="status" style="display:none;">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>

            </form>
        </div>
    </div>
</div>
