{{-- <script src="{{ asset('assets/js/jquery.min.js') }}"></script> --}}
<script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('assets/js/additional-methods.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/localization/messages_ar.js"></script>
<script>
    $(document).ready(function() {
        // Reset form and hide previews when modal is closed
        $('#kt_modal_add_edit').on('hidden.bs.modal', function() {
            $('.error').text('');
            $('#my-form').attr('action', "{{ route('dashboard.exams.store') }}");

            $('#my-form')[0].reset();
            $('#add_edit_class_room_id').val('').trigger('change.select2');
            $('#add_edit_material_id').val('').trigger('change.select2');
            $('#add_edit_chapter_id').val('').trigger('change.select2');

        });


        $('#search_class_room_id,#search_chapter_id,#search_material_id').on('change', function() {
            table.draw();
        });
        // DataTable initialization
        var table = $('#data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('dashboard.exams.getIndex') }}",
                data: function(d) {
                    d.search_class_room_id = $('#search_class_room_id').val();
                    d.search_material_id = $('#search_material_id').val();
                    d.search_chapter_id = $('#search_chapter_id').val();

                },
            },
            columns: [


                {
                    data: 'name',
                    name: 'name'
                },

                {
                    data: 'classRooms',
                    name: 'classRooms',
                },
                {
                    data: 'materials',
                    name: 'materials',
                },

                {
                    data: 'question_count',
                    name: 'question_count',
                },


                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
            ],
            order: [
                [1, 'desc']
            ]
        });

        // Search filter
        $('[data-kt-data-table-filter="search"]').on('keyup', function() {
            table.search(this.value).draw();
        });



        // Show modal if needed
        if ($('#show_modal').val()) {
            $('#kt_modal_add_edit').modal('show');
        }

        // Form validation and AJAX submit
        $('#my-form').validate({
            rules: {
                name: {
                    required: true,
                },

                exam_time: {
                    required: true,
                },
                class_room_id: {
                    required: true,

                },

                material_id: {
                    required: true,

                },
                question_count: {
                    required: true,

                }


            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages
                $('#submit-button').prop('disabled',
                    true); // Disable submit button to prevent multiple submissions

                var url = $('#my-form').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        // Handle the response on success
                        if (response.success) {
                            toastr.success(response.message,
                                'نجاح العملية', {
                                    timeOut: 3000
                                });
                            $('#kt_modal_add_edit').modal('hide');
                            $('#data-table').DataTable().ajax.reload();
                        } else {
                            toastr.error(response.message, 'Error', {
                                timeOut: 3000
                            });
                        }
                    },
                    error: function(xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            // Loop through the validation errors and display them with toastr
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                // Show the error messages in the corresponding fields
                                var errorContainer = $('#' + field + '_error');
                                errorContainer.text(messages.join(', '))
                                    .show(); // Join messages if there are multiple
                            });
                        } else {
                            // For other errors, display a general error message
                            toastr.error(
                                '{{ __('messages.An error occurred. Please try again later') }}',
                                'Error', {
                                    timeOut: 3000
                                });
                        }
                    }
                });
            }
        });




// Assume 'selectedChapters' contains the list of chapter IDs that should be checked.




// Global variable to store selected chapters
var selectedChapters = [];

// Edit button click handler
$(document).on('click', '.edit', function() {
    var examId = $(this).data('exam_id');
    var name = $(this).data('name');
    var examTime = $(this).data('exam_time');
    var questionCount = $(this).data('question_count');
    var materialId = $(this).data('material_id');
    var classRoomId = $(this).data('class_room_id');

    // Parse the selected chapters and store in global variable
    selectedChapters = JSON.parse($(this).attr('data-chapters'));

    $('#add_edit_class_room_id').val(classRoomId).trigger('change.select2');
    $('#my-form').attr('action', "{{ route('dashboard.exams.update') }}");
    $('#add_edit_name').val(name);
    $('#add_edit_exam_id').val(examId);
    $('#add_edit_exam_time').val(examTime);
    $('#add_edit_question_count').val(questionCount);

    // Load materials based on the selected classroom
    $.ajax({
        url: '{{ route('dashboard.chapters.getMaterials') }}',
        type: 'GET',
        data: { class_room_id: classRoomId },
        success: function(response) {
            $('#add_edit_material_id').empty().append('<option value="">اختر</option>');
            $.each(response.materials, function(key, value) {
                $('#add_edit_material_id').append('<option value="' + value.id + '">' + value.name + '</option>');
            });
            $('#add_edit_material_id').val(materialId).change();
        }
    });

    // Load chapters based on the selected material
    loadChapters(materialId);
    $('#kt_modal_add_edit').modal('show');
});

// Change event for material selection
$('#add_edit_material_id').on('change', function() {
    var materialId = $(this).val();
    loadChapters(materialId);
});

// Function to load chapters and apply selected checkboxes
function loadChapters(materialId) {
    $.ajax({
        url: '{{ route('dashboard.exams.getchapters') }}',
        type: 'GET',
        data: { material_id: materialId },
        success: function(response) {
            $('#chapter-container').empty();
            var checkboxHtml = '<div class="row">';

            response.chapters.forEach(function(chapter, index) {
                // Check if this chapter ID is in the selectedChapters array
                var isChecked = selectedChapters.includes(chapter.id) ? 'checked' : '';

                checkboxHtml += `
                <div class="col-lg-4 col-md-6 col-sm-12 mt-1 mb-1">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="${chapter.id}" name="chapterIds[]" ${isChecked}>
                        <label class="form-check-label">
                            ${chapter.title} <br>
                            (عدد الاسئلة: ${chapter.questions_count})
                        </label>
                    </div>
                </div>
                `;

                if ((index + 1) % 3 === 0) {
                    checkboxHtml += '</div><div class="row">';
                }
            });

            checkboxHtml += '</div>'; // Close the final row
            $('#chapter-container').append(checkboxHtml);
        }
    });
}






    $('#add_edit_class_room_id,#search_class_room_id').on('change', function() {
        const classRoomId = $(this).val();
        $('#add_edit_material_id').empty().append('<option value="">اختر</option>');
        $('#add_edit_chapter_id').empty().append('<option value="">اختر</option>');

        $('#search_material_id').empty().append('<option value="">اختر</option>');
        $('#search_chapter_id').empty().append('<option value="">اختر</option>');

        if (classRoomId) {
            $.ajax({
                url: '{{ route('dashboard.chapters.getMaterials') }}', // Adjust route as needed
                type: 'GET',
                data: {
                    class_room_id: classRoomId
                },
                success: function(data) {
                    // console.log(data.materials);
                    data.materials.forEach(function(material) {
                        $('#add_edit_material_id').append(
                            `<option value="${material.id}">${material.name}</option>`
                        );
                        $('#search_material_id').append(
                            `<option value="${material.id}">${material.name}</option>`
                        );
                    });
                }
            });
        }
    });






    // Delete button click
    $(document).on('click', '.delete', function(e) {
        e.preventDefault();
        var name_delete = $(this).data('name_delete');
        var ids = $(this).data('id');
        $('#Delete_id').val(ids);
        $('#Name_Delete').val(name_delete);
        $('#confirmModal').modal('show');
    });
    // Confirm delete action
    $(document).on('click', '.delete_submit', function(e) {
        e.preventDefault();

        var ids = $('#Delete_id').val();
        $('#confirmModal').modal('hide');

        // Perform the AJAX delete request
        $.ajax({
            url: '{{ route('dashboard.materials.delete') }}',
            method: 'POST',
            data: {
                "id": ids,
                "_token": "{{ csrf_token() }}"
            },
            success: function(response) {
                if (response.success) {
                    // Show success notification
                    toastr.success(response.message, 'Success', {
                        timeOut: 3000
                    });

                    // Reload the DataTable
                    $('#data-table').DataTable().ajax.reload();
                } else {
                    // Show error notification
                    toastr.error(response.message, 'Error', {
                        timeOut: 3000
                    });
                }
            },
            error: function(xhr) {
                // Hide the spinner and enable the submit button

                // For other errors, display a general error message
                toastr.error('هناك خطا ما يرجى المحاولى لاحقا',
                    'فشل العملية', {
                        timeOut: 3000
                    });


            }
        });
    });



    });
</script>
