<script src="{{ asset('assets/js/additional-methods.min.js') }}"></script>
<script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/localization/messages_ar.js"></script>

<script>
    $(document).ready(function() {
        // Reset form and modal previews when modal is hidden
        $('#kt_modal_add_edit').on('hidden.bs.modal', function () {
            $('.error').text('');
            $('.modal-title').text('اضافة بيانات المحافظة');
            const form = $('#my-form'); // The form you want to set the action for
            form.attr('action', "{{ route('dashboard.governorates.store') }}");
            resetForm();
        });

        // Initialize DataTable
        var table = $('#data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('dashboard.governorates.getIndex') }}",
            columns: [
                { data: 'name', name: 'name' },
                { data: 'actions', name: 'actions', orderable: false, searchable: false }
            ],
            order: [[1, 'desc']]
        });

        // Search filter
        $('[data-kt-data-table-filter="search"]').on('keyup', function () {
            table.search(this.value).draw();
        });

        // Show modal if necessary
        let show_modal = $('#show_modal').val();
        if (show_modal) {
            $('#kt_modal_add_edit').modal('show');
        }
    });

    // Reset form fields
    function resetForm() {
        $('#my-form')[0].reset();
        $('#is-active').prop('checked', true);
    }

    // Form validation and submission
    $('#my-form').validate({
        rules: {
            name: { required: true },
        },
        submitHandler: function(form) {
            $('#spinner').show();
            $('#submit-button').prop('disabled', true);
            var url = $('#my-form').attr('action');
            $.ajax({
                url: url,
                type: 'POST',
                data: new FormData(form),
                processData: false,
                contentType: false,
                success: function(response) {
                    $('#spinner').hide();
                    $('#submit-button').prop('disabled', false);

                    if (response.success) {
                        toastr.success(response.message, 'Success', { timeOut: 3000 });
                        $('#kt_modal_add_edit').modal('hide');
                        $('#data-table').DataTable().ajax.reload(null, false);
                    } else {
                        toastr.error(response.message, 'Error', { timeOut: 3000 });
                    }
                },
                error: function() {
                    $('#spinner').hide();
                    $('#submit-button').prop('disabled', false);
                }
            });
        }
    });

    // View button click
    $(document).on('click', '.view', function() {
        $('#view_name').val($(this).data('name'));
        $('.modal-title').text('عرض بيانات المحافظة');
        $('#kt_modal_view').modal('show');
    });

    // Edit button click
    $(document).on('click', '.edit', function() {
        $('.show_active').show();
        $('.modal-title').text('تعديل بيانات المحافظة');
        $('#add_edit_name').val($(this).data('name'));
        $('#governorate_id').val($(this).data('id'));
        $('#my-form').attr('action', "{{ route('dashboard.governorates.update') }}");
        $('#kt_modal_add_edit').modal('show');
    });

    // Delete button click
    $(document).on('click', '.delete', function(e) {
        e.preventDefault();
        var name_delete = $(this).data('name_delete');
        var ids = $(this).data('id');
        $('#Delete_id').val(ids);
        $('#Name_Delete').val(name_delete);
        $('#confirmModal').modal('show');
    });

    // Confirm delete action
    $(document).on('click', '.delete_submit', function(e) {
        e.preventDefault();
        var ids = $('#Delete_id').val();
        $('#confirmModal').modal('hide');

        $.ajax({
            url: '{{ route('dashboard.governorates.delete') }}',
            method: 'POST',
            data: {
                "id": ids,
                "_token": "{{ csrf_token() }}"
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message, 'Success', { timeOut: 3000 });
                    $('#data-table').DataTable().ajax.reload(null, false);
                } else {
                    toastr.error(response.message, 'Error', { timeOut: 3000 });
                }
            },
            error: function() {
                toastr.error('An error occurred. Please try again later.', 'Error', { timeOut: 3000 });
            }
        });
    });
</script>
