<script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('assets/js/additional-methods.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/localization/messages_ar.js"></script>

<script>
    $(document).ready(function() {
        // Reset form and hide previews when modal is closed
        $('#kt_modal_add_edit').on('hidden.bs.modal', function() {
            $('.error').text('');
            $('.modal-title').text('اضافة مستوى داراسي جديدة');
            $('#my-form').attr('action', "{{ route('dashboard.levels.store') }}");
            $('#my-form')[0].reset();
            $('#add_edit_class_roomi_id').val('').trigger('change.select2');
        });

        var table = $('#data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('dashboard.levels.getIndex') }}",
            },
            columns: [
                { data: 'code', name: 'code' },
                { data: 'name', name: 'name' },
                { data: 'actions', name: 'actions', orderable: false, searchable: false }
            ],
            order: [[1, 'desc']]
        });

        // Search filter
        $('[data-kt-data-table-filter="search"]').on('keyup', function() {
            table.search(this.value).draw();
        });

        // Show modal if needed
        if ($('#show_modal').val()) {
            $('#kt_modal_add_edit').modal('show');
        }

        // Form validation and AJAX submit
        $('#my-form').validate({
            rules: {
                name: { required: true },
                code: { required: true },
            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide();
                $('#submit-button').prop('disabled', true);

                var url = $('#my-form').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (response.success) {
                            toastr.success(response.message, 'نجاح العملية', { timeOut: 3000 });
                            $('#kt_modal_add_edit').modal('hide');
                            $('#data-table').DataTable().ajax.reload(null, false);
                        } else {
                            toastr.error(response.message, 'Error', { timeOut: 3000 });
                        }
                    },
                    error: function(xhr) {
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                var errorContainer = $('#' + field);
                                errorContainer.text(messages.join(', ')).show();
                            });
                        } else {
                            toastr.error('هناك خطا ما يرجى المحاولة لاحقا', 'Error', { timeOut: 3000 });
                        }
                    }
                });
            }
        });

        // Handle modal view and edit actions
        $(document).on('click', '.view, .edit', function() {
            const action = $(this).hasClass('view') ? 'view' : 'add_edit';
            const title = $(this).hasClass('view') ? 'عرض بيانات المرحلة الدراسية' : 'تعديل بيانات المرحلة الدراسية';
            const form = $('#my-form');

            form.attr('action', "{{ route('dashboard.levels.update') }}");

            const fields = ['code', 'name', 'level_id'];
            fields.forEach(field => {
                $('#' + action + '_' + field).val($(this).data(field));
            });

            var classRoomId = $(this).data('classroomid');
            $('#add_edit_class_room_id').val(classRoomId).trigger('change.select2');

            $('.modal-title').text(title);
            $('#kt_modal_' + action).modal('show');
        });

        // Delete button click
        $(document).on('click', '.delete', function(e) {
            e.preventDefault();
            var name_delete = $(this).data('name_delete');
            var ids = $(this).data('id');
            $('#Delete_id').val(ids);
            $('#Name_Delete').val(name_delete);
            $('#confirmModal').modal('show');
        });

        // Confirm delete action
        $(document).on('click', '.delete_submit', function(e) {
            e.preventDefault();

            var ids = $('#Delete_id').val();
            $('#confirmModal').modal('hide');

            $.ajax({
                url: '{{ route('dashboard.levels.delete') }}',
                method: 'POST',
                data: { "id": ids, "_token": "{{ csrf_token() }}" },
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message, 'Success', { timeOut: 3000 });
                        $('#data-table').DataTable().ajax.reload(null, false);
                    } else {
                        toastr.error(response.message, 'فشل العملية', { timeOut: 3000 });
                    }
                },
                error: function() {
                    toastr.error('هناك خطا ما يرجى المحاولى لاحقا', 'فشل العملية', { timeOut: 3000 });
                }
            });
        });
    });
</script>
