@extends('layouts.master')
@section('main_title', 'قائمةالمواد التعليمية')
@section('main_page', 'المواد التعليمية')
@section('title', 'المواد التعليمية')

@section('content')
    <style>
        #chaptersContainer {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            /* Optional: Adds space between items */
        }
    </style>
    <div id="kt_app_content_container" class="app-container container-fluid">
        <!--begin::Row-->
        <div class="row g-5 gx-xl-10 mb-5 mb-xl-10">

            <div class="card">
                <!--begin::Card header-->
                <div class="card-header border-0 pt-6">
                    <!--begin::Card title-->
                    <div class="card-title">
                        <!--begin::Search-->
                        <div class="d-flex align-items-center position-relative my-1">
                            <i class="ki-duotone ki-magnifier fs-3 position-absolute ms-5">
                                <span class="path1"></span>
                                <span class="path2"></span>
                            </i>
                            <input type="text" data-kt-data-table-filter="search"
                                class="form-control form-control-solid w-250px ps-12" placeholder="Search" />
                        </div>

                        <div class="d-flex align-items-center position-relative my-1">
                            <select class="form-select ms-2 form-control form-control-solid w-250px ps-12" data-dir="rtl"
                                style="width: 100%" id="search_class_room_id" data-control="select2"
                                name="search_class_room_id" data-placeholder="المراحل التعليمية ">
                                <option value="-1" selected>المراحل التعليمية</option>
                                <option value="">المراحل التعليمية</option>

                                @foreach ($classRooms as $value)
                                    <option value="{{ $value->id }}">{{ $value->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <!--end::Search-->
                    </div>
                    <!--begin::Card title-->
                    <!--begin::Card toolbar-->
                    <div class="card-toolbar">
                        <!--begin::Toolbar-->
                        <div class="d-flex justify-content-end" data-kt-customer-table-toolbar="base">
                            <!--begin::Filter-->

                            <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                data-bs-target="#kt_modal_add_edit">اضافة مادة تعليمية جديدة</button>
                            <!--end::Add customer-->
                        </div>
                        <!--end::Toolbar-->
                        <!--begin::Group actions-->
                        <div class="d-flex justify-content-end align-items-center d-none"
                            data-kt-customer-table-toolbar="selected">
                            <div class="fw-bold me-5">
                                <span class="me-2" data-kt-customer-table-select="selected_count"></span>Selected
                            </div>
                            <button type="button" class="btn btn-danger"
                                data-kt-customer-table-select="delete_selected">Delete Selected</button>
                        </div>
                        <!--end::Group actions-->
                    </div>
                    <!--end::Card toolbar-->
                </div>
                <!--end::Card header-->
                <!--begin::Card body-->
                <div class="card-body pt-0">
                    <!--begin::Table-->
                    <table class="table align-middle table-row-dashed fs-6 gy-5" id="data-table">



                        <thead>
                            <tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase gs-0">

                            <tr class="fw-semibold fs-6 text-gray-800">

                                <th>الاسم</th>
                                <th>المرحلة الدراسية</th>
                                <th></th>
                            </tr>

                        </thead>
                        <tbody>

                        </tbody>

                    </table>
                </div>
            </div>

        </div>
    </div>


    <input type="hidden" name="show_modal" id="show_modal" value="{{ $modal }}">

    @include('dashboard.matireals.Model.create_update')
    @include('dashboard.matireals.Model.view')


    <div class="modal fade" id="attachmentModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel"
        aria-modal="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="add_attachment_modal-title" id="modalLabel">اضافة مرفقات</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="save-attachments" action="{{ route('dashboard.materials.addAttachment') }}" method="post">

                        @csrf
                        <div class="form-group row">
                            <div class="col-6">
                                <label class="form-label">العنوان <span class="required"></span></label>
                                <select class="form-control" name="attachment_title">
                                    <option value="">اختر</option>
                                    <option value="الكتاب المدرسي">الكتاب المدرسي</option>
                                    <option value="اسئلة">اسئلة</option>
                                    <option value="اختبارات عامة">اختبارات عامة</option>
                                </select>
                            </div>


                            <input type="hidden" name="attachment_matireal_id" id="add_attachment_matireal_id">

                            <div class="col-lg-6 col-sm-12">
                                <label for="attachment" class="form-label">المرفق <span class="required"></span></label>

                                <input type="file" id="attachment_book" name="attachment_book"
                                    class="form-control form-control-solid">
                                @error('attachment_book')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror


                            </div>
                        </div>
                </div>

                <!-- Submit Button -->
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" form="save-attachments">
                        <i class="ki ki-submit-duotone fs-2"></i>تاكيد
                    </button>

                    <!-- Cancel Button -->
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                        <i class="ki ki-times-duotone fs-2"></i> الغاء
                    </button>
                </div>
                </form>
            </div>
        </div>
    </div>
    </div>

    <div class="modal fade" id="allAttachmentModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel"
        aria-modal="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="attachment_modal-title" id="modalLabel">عرض المرفقات</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <table class="table align-middle table-row-dashed fs-6 gy-5">


                        <thead>
                            <tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase gs-0">

                            <tr class="fw-semibold fs-6 text-gray-800">

                                <th>عنوان مرفق</th>
                                <th>المرفق</th>
                            </tr>

                        </thead>
                        <tbody id="attachmentTableBody">

                        </tbody>

                        <!-- Submit Button -->
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="addChapterModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel"
        aria-modal="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalLabel">إضافة بيانات الوحدة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="addChapterForm" action="{{ route('dashboard.materials.addchapter') }}" method="POST">
                        @csrf

                        <input type="hidden" name="add_chapter_matireal_id" id="add_chapter_matireal_id">
                        <div id="repeater">
                            <!-- Repeated Chapter Section -->
                            <div class="chapter-item mb-3">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="chapter_code" class="form-label">الكود</label>
                                        <input type="text" name="chapter_code[]" class="form-control"
                                            placeholder="الكود">
                                    </div>
                                    <div class="col-6">
                                        <label for="chapter_title" class="form-label">العنوان</label>
                                        <input type="text" name="chapter_title[]" class="form-control"
                                            placeholder="العنوان">
                                    </div>
                                </div>

                                <div class="row">

                                    <div class="col-12">
                                        <label for="chapter_description" class="form-label">الوصف</label>
                                        <textarea name="chapter_description[]" class="form-control"></textarea>
                                    </div>
                                </div>

                                <button type="button" class="btn btn-danger mt-2 remove-chapter"><i
                                        class="fa fa-trash"></i> حذف</button>
                                <hr>
                            </div>
                        </div>
                        <button type="button" class="btn btn-light add-chapter"><i class="fa fa-plus"></i>
                            إضافة</button>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">الغاء</button>
                            <button type="submit" class="btn btn-primary" form="addChapterForm">تأكيد <i
                                    class="fa fa-paper-plane"></i></button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>

    <div class="modal fade" id="allChapterModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel"
        aria-modal="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalLabel">إضافة بيانات الوحدة</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <table class="table align-middle table-row-dashed fs-6 gy-5">


                        <thead>
                            <tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase gs-0">

                            <tr class="fw-semibold fs-6 text-gray-800">

                                <th>الكود</th>
                                <th>العنوان</th>
                                <th>المرحلة الدراسية</th>
                                <th>المادة</th>
                            </tr>
                        </thead>
                        <tbody id="chapterTableBody">

                        </tbody>

                        <!-- Submit Button -->
                    </table>
                </div>

            </div>
        </div>
    </div>



    <div class="modal fade" id="addExamModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel"
        aria-modal="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalLabel">إضافة امتحان جديد</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="addExamForm" action="{{ route('dashboard.materials.addExam') }}" method="POST">
                        @csrf

                        <input type="hidden" name="add_exam_material_id" id="add_exam_material_id">

                        <div class="row">
                            <div class="col-6">
                                <label for="exam_name" class="form-label">اسم الامتحان</label>
                                <input type="text" name="exam_name" class="form-control" placeholder="اسم الامتحان">
                            </div>
                            <div class="col-6">
                                <label for="question_count" class="form-label">عدد الاسئلة</label>
                                <input type="text" name="question_count" id="question_count" class="form-control"
                                    placeholder="عدد الاسئلة">
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-12">
                                <label for="chapters" class="form-label">اختر الفصول</label>
                                <div id="chaptersContainer"></div>
                                <!-- Dynamic chapter checkboxes will be appended here -->
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">الغاء</button>
                            <button type="submit" class="btn btn-primary">تأكيد <i
                                    class="fa fa-paper-plane"></i></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <!-- Modal to Show Exams -->
    <div class="modal fade" id="examListModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalLabel">قائمة الامتحانات</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <table class="table align-middle table-row-dashed fs-6 gy-5">
                        <thead>
                            <tr class="text-start text-gray-500 fw-bold fs-7 text-uppercase gs-0">
                                <th>اسم الامتحان</th>
                                <th>عدد الأسئلة</th>
                            </tr>
                        </thead>
                        <tbody id="examTableBody">
                            <!-- Exams will be appended here -->
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                </div>
            </div>
        </div>
    </div>




    @include('Shared.delete')
@endsection

@section('scripts')
    @include('dashboard.matireals.js.js')
@endsection
