@extends('layouts.master')
@section('main_title', 'الاشعارات')
@section('main_page', 'الاشعارات')
@section('title', 'الاشعارات')

@section('content')

    <div id="kt_app_content_container" class="app-container container-fluid">
        <!--begin::Row-->
        <div class="row g-5 gx-xl-10 mb-5 mb-xl-10">

            <div class="card">
                <!--begin::Card header-->
                <div class="card-header border-0 pt-6">
                    <!--begin::Card title-->
                    {{-- <div class="card-title">
                        <!--begin::Search-->
                        <div class="d-flex align-items-center position-relative my-1">
                            <i class="ki-duotone ki-magnifier fs-3 position-absolute ms-5">
                                <span class="path1"></span>
                                <span class="path2"></span>
                            </i>
                        </div>
                        <!--end::Search-->
                    </div> --}}
                    <!--begin::Card title-->
                    <!--begin::Card toolbar-->
                    <div class="card-toolbar">
                        <!--begin::Toolbar-->

                        <!--end::Toolbar-->
                        <!--begin::Group actions-->
                        <div class="d-flex justify-content-end align-items-center d-none"
                            data-kt-customer-table-toolbar="selected">
                            <div class="fw-bold me-5">
                                <span class="me-2" data-kt-customer-table-select="selected_count"></span>Selected
                            </div>
                            <button type="button" class="btn btn-danger"
                                data-kt-customer-table-select="delete_selected">Delete Selected</button>
                        </div>
                        <!--end::Group actions-->
                    </div>
                    <!--end::Card toolbar-->
                </div>
                <!--end::Card header-->
                <!--begin::Card body-->
                <form id="my-form" method="post" action="{{ route('dashboard.notifications.store') }}"
                    enctype="multipart/form-data">

                    @csrf
                    <div class="card-body pt-0">


                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label for="add_edit_driver_id" class="form-label">الطلاب</label>
                                <select class="form-select form-control-solid" id="add_edit_driver_id"
                                    data-control="select2" name="user_id[]" multiple>
                                    <option value="">{{ __('messages.select') }}</option>
                                    @foreach ($students as $value)
                                        <option value="{{ $value->id }}">{{ $value->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="add_edit_title" class="form-label">العنوان <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-solid" id="add_edit_title"
                                    name="title" required>
                            </div>



                        </div>

                        <div class="row mb-4">
                            <label for="city_id" class="form-label">الوصف</label>

                            <textarea class="form-control form-control-solid" name="body"></textarea>
                        </div>

                        <div class="row mb-4">

                            <div class="col-md-2">

                                <button type="submit" class="btn btn-primary" form="my-form">
                                    <i class="fa fa-paper-plane" aria-hidden="true"></i>
                                   تاكيد
                                </button>

                                <div id="spinner" class="spinner-border text-primary" role="status"
                                    style="display:none;">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                            </div>

                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
    @endsection
    @section('scripts')
    @include('dashboard.notifications.js.js')
    @endsection
