<script src="{{ asset('assets/js/additional-methods.min.js') }}"></script>
<script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/localization/messages_ar.js"></script>

<script>
    $(document).ready(function() {
        $('#kt_account_profile_details_form').validate({
            rules: {
                name: { required: true },
                email: { required: true, email: true },
                phone: { required: true, digits: true },
            },

            submitHandler: function (form) {
                // Show the spinner and disable the submit button
                $('#spinner').show();
                $('#submit-button').prop('disabled', true);

                // AJAX request to submit the form data
                $.ajax({
                    url: '{{ route('dashboard.profile.profile') }}', // Update with your URL
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    beforeSend: function () {
                        $('.text-danger').text('');
                        // You could add a loading spinner here if needed
                    },
                    success: function (response) {
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        // Handle the response on success
                        if (response.success) {
                            toastr.success('<i class="las la-tint text-success"></i> ' + response.message, '{{ __('messages.success') }}');
                            window.location.reload();

                        } else {
                            toastr.error("An error occurred while updating your profile.");
                        }
                    },
                    error: function (xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        // Check if there are validation errors
                        if (xhr.status === 422) {
                            // Unprocessable Entity
                            const errors = xhr.responseJSON.errors;
                            if (errors) {
                                for (const [key, messages] of Object.entries(errors)) {
                                    messages.forEach(message => {
                                        toastr.error(message); // Display each error message
                                    });
                                    $('.'+key).text(messages);

                                }
                            } else {
                                toastr.error("An error occurred while updating your profile.");
                            }
                        } else {
                            toastr.error("An unexpected error occurred.");
                        }
                    }
                });
            }
        });


        $('#kt_account_profile_password_form').validate({
            rules: {
                current_password: { required: true },
                new_password: { required: true, },
                confirm_new_password: { required: true },
            },

            submitHandler: function (form) {
                // Show the spinner and disable the submit button
                $('#spinner').show();
                $('#password_submit-button').prop('disabled', true);

                // AJAX request to submit the form data
                $.ajax({
                    url: '{{ route('dashboard.profile.changePassword') }}', // Update with your URL
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    beforeSend: function () {
                        $('.text-danger').text('');
                        // You could add a loading spinner here if needed
                    },
                    success: function (response) {
                        $('#password_spinner').hide();
                        $('#password_submit-button').prop('disabled', false);

                        // Handle the response on success
                        if (response.success) {
                            toastr.success('<i class="las la-tint text-success"></i> ' + response.message, '{{ __('messages.success') }}');

                            window.location.reload();
                        } else {
                            toastr.error("An error occurred while updating your profile.");
                        }
                    },
                    error: function (xhr) {
                        // Hide the spinner and enable the submit button
                        $('#password_spinner').hide();
                        $('#password_submit-button').prop('disabled', false);

                        // Check if there are validation errors
                        if (xhr.status === 422) {
                            // Unprocessable Entity
                            const errors = xhr.responseJSON.errors;
                            if (errors) {
                                for (const [key, messages] of Object.entries(errors)) {
                                    messages.forEach(message => {
                                        toastr.error(message); // Display each error message
                                    });
                                    $('.'+key).text(messages);

                                }
                            } else {
                                toastr.error("An error occurred while updating your profile.");
                            }
                        } else {
                            toastr.error("An unexpected error occurred.");
                        }
                    }
                });
            }
        });


    });
</script>
