ي{{-- <script src="{{ asset('assets/js/jquery.min.js') }}"></script> --}}
<script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('assets/js/additional-methods.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/localization/messages_ar.js"></script>
<script>
    $(document).ready(function() {
        // Reset form and hide previews when modal is closed
        $('#kt_modal_add_edit').on('hidden.bs.modal', function() {
            $('.error').text('');
            $('#my-form')[0].reset();
            $('#add_edit_class_room_id').val('').trigger('change.select2');

            $('#add_edit_image-preview').hide();
            $('#add_edit_image-preview').attr('src', '#');

        });






        // DataTable initialization
        var table = $('#data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('dashboard.roles.getIndex') }}",

            },
            columns: [{
                    data: 'name',
                    name: 'name'
                },


                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
            ],
            order: [
                [1, 'desc']
            ]
        });

        // Search filter
        $('[data-kt-data-table-filter="search"]').on('keyup', function() {
            table.search(this.value).draw();
        });



        // Show modal if needed
        if ($('#show_modal').val()) {
            $('#kt_modal_add_edit').modal('show');
        }

        // Form validation and AJAX submit
        $('#my-form').validate({
            rules: {
                name: {
                    required: true,
                },
                // "permission_elements[]":{
                //     required: true,
                // },


                permission_id: {
                    required: true,
                    array: true,

                },




            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages
                $('#submit-button').prop('disabled',
                    true); // Disable submit button to prevent multiple submissions

                var url = $('#my-form').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        // Handle the response on success
                        if (response.success) {
                            toastr.success(response.message,
                                'نجاح العملية', {
                                    timeOut: 3000
                                });
                            $('#kt_modal_add_edit').modal('hide');
                            // $('#data-table').DataTable().ajax.reload();
                            $('#data-table').DataTable().ajax.reload(null, false);

                        } else {
                            toastr.error(response.message, 'Error', {
                                timeOut: 3000
                            });
                        }
                    },
                    error: function(xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            // Loop through the validation errors and display them with toastr
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                // Show the error messages in the corresponding fields
                                var errorContainer = $('.' + field);
                                errorContainer.text(messages.join(', '))
                                    .show(); // Join messages if there are multiple
                            });
                        } else {
                            // For other errors, display a general error message
                            toastr.error(
                                '{{ __('messages.An error occurred. Please try again later') }}',
                                'Error', {
                                    timeOut: 3000
                                });
                        }
                    }
                });
            }
        });


        // Handle modal view and edit actions
        $(document).on('click', '.view, .edit', function () {
    const isView = $(this).hasClass('view');
    const action = isView ? 'view' : 'add_edit';
    const title = isView ? 'عرض بيانات الصلاحيات' : 'تعديل بيانات الصلاحيات';

    // تعيين مسار النموذج
    $('#my-form').attr('action', "{{ route('dashboard.roles.update') }}");

    // تعبئة الحقول من البيانات
    ['name', 'role_id'].forEach(field => {
        $('#' + action + '_' + field).val($(this).data(field));
    });

    // الحصول على الصلاحيات كمصفوفة آمنة
    let permissions = [];
    try {
        permissions = JSON.parse($(this).attr('data-permissions')) || [];
    } catch (e) {
        console.error("Invalid JSON format for permissions:", e);
    }

    // إعادة تعيين جميع الـ checkboxes
    const modal = $('.modal');
    modal.find('input[name="permission_elements[]"]').prop('checked', false);

    // تحديد الـ checkboxes الخاصة بالصلاحيات
    modal.find('input[name="permission_elements[]"]').filter((_, el) =>
        permissions.includes(parseInt(el.value))
    ).prop('checked', true);

    // ضبط عنوان المودال وعرضه
    $('.modal-title').text(title);
    $('#kt_modal_add_edit').modal('show');
});




    });












    // Delete button click
    $(document).on('click', '.delete', function(e) {
        e.preventDefault();
        var name_delete = $(this).data('name_delete');
        var ids = $(this).data('id');
        $('#Delete_id').val(ids);
        $('#Name_Delete').val(name_delete);
        $('#confirmModal').modal('show');
    });
    // Confirm delete action
    $(document).on('click', '.delete_submit', function(e) {
        e.preventDefault();

        var ids = $('#Delete_id').val();
        $('#confirmModal').modal('hide');

        // Perform the AJAX delete request
        $.ajax({
            url: '{{ route('dashboard.roles.delete') }}',
            method: 'POST',
            data: {
                "id": ids,
                "_token": "{{ csrf_token() }}"
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message, 'Success', {
                        timeOut: 3000
                    });
                    $('#data-table').DataTable().ajax.reload(null, false);

                    // $('#data-table').DataTable().ajax.reload();
                } else {
                    // Show error notification
                    toastr.error(response.message, 'Error', {
                        timeOut: 3000
                    });
                }
            },
            error: function(xhr) {
                // Hide the spinner and enable the submit button

                // For other errors, display a general error message
                toastr.error('هناك خطا ما يرجى المحاولى لاحقا',
                    'فشل العملية', {
                        timeOut: 3000
                    });


            }
        });
    });
</script>
