<script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('assets/js/additional-methods.min.js') }}"></script>
@if (app()->getLocale() === 'ar')
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/localization/messages_ar.js"></script>
@endif
<script>
    $(document).ready(function() {

        $("#upload-form").validate({
            rules: {
                "excel_file": {
                    required: true,
                },
            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages
                $('#submit-button').prop('disabled', true); // Disable submit button to prevent multiple submissions

                var url = $('#upload-form').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        $('#spinner').hide();
                        $('#kt_modal_upload_excel').modal('hide');
                        $('#upload-form')[0].reset();
                        if (response.success) {
                            toastr.success(response.message, 'Success');
                            $('#data-table').DataTable().ajax.reload(null, false);
                        } else {
                            if (response.errors) {
                                console.log('Validation Errors:', response.errors);
                            }

                            if (response.download_url) {
                                toastr.success(response.message, 'Success');
                                window.location.href = response.download_url;
                            }
                        }
                    },
                    error: function(xhr) {
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                var errorContainer = $('#' + field + '_error');
                                errorContainer.text(messages.join(', ')).show();
                            });
                        } else {
                            toastr.error('{{ __('messages.An error occurred. Please try again later') }}', 'Error', { timeOut: 3000 });
                        }
                    }
                });
            }
        });

        $('#kt_modal_add_edit').on('hidden.bs.modal', function() {
            $('.error').text('');
            $('.modal-title').text('اضافة بيانات المدرسة التعليمية');
            $('#add_edit_education_area_id').val('').trigger('change.select2');
            const form = $('#my-form');
            form.attr('action', "{{ route('dashboard.schools.store') }}");
            $('#add_edit_name').val('');
            $('#my-form')[0].reset();
        });

        $('#search_education_area_id').on('change', function() {
            table.draw();
        });

        var table = $('#data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('dashboard.schools.getIndex') }}",
                data: function(d) {
                    d.search_education_area_id = $('#search_education_area_id').val();
                },
            },
            columns: [
                { data: 'name', name: 'name' },
                { data: 'educationalAreas', name: 'educationalAreas' },
                { data: 'actions', name: 'actions', orderable: false, searchable: false }
            ],
            order: [[1, 'desc']]
        });

        $('[data-kt-data-table-filter="search"]').on('keyup', function() {
            table.search(this.value).draw();
        });

        if ($('#show_modal').val()) {
            $('#kt_modal_add_edit').modal('show');
        }

        $('#my-form').validate({
            rules: {
                name: { required: true },
                education_area_id: { required: true },
            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide();
                $('#submit-button').prop('disabled', true);

                var url = $('#my-form').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (response.success) {
                            toastr.success(response.message, 'نجاح العملية', { timeOut: 3000 });
                            $('#kt_modal_add_edit').modal('hide');
                            $('#data-table').DataTable().ajax.reload(null, false);
                        } else {
                            toastr.error(response.message, 'Error', { timeOut: 3000 });
                        }
                    },
                    error: function(xhr) {
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                var errorContainer = $('#' + field);
                                errorContainer.text(messages.join(', ')).show();
                            });
                        } else {
                            toastr.error('هناك خطا ما يرجى المحاولة لاحقا', 'فشل العملية', { timeOut: 3000 });
                        }
                    }
                });
            }
        });

        $(document).on('click', '.view, .edit', function() {
            const action = $(this).hasClass('view') ? 'view' : 'add_edit';
            const title = $(this).hasClass('view') ? 'عرض بيانات المدرسة التعليمية' : 'تعديل بيانات المدرسة التعليمية';
            const form = $('#my-form');
            form.attr('action', "{{ route('dashboard.schools.update') }}");

            const fields = ['education_area_id', 'name', 'school_id'];
            fields.forEach(field => {
                $('#' + action + '_' + field).val($(this).data(field));
            });

            const educationAreaId = $(this).data('education_area_id');
            if (educationAreaId) {
                $('#'+action+'_education_area_id').val(educationAreaId).trigger('change.select2');
            }

            $('.modal-title').text(title);
            $('#kt_modal_' + action).modal('show');
        });

    });

    $(document).on('click', '.delete', function(e) {
        e.preventDefault();
        var name_delete = $(this).data('name_delete');
        var ids = $(this).data('id');
        $('#Delete_id').val(ids);
        $('#Name_Delete').val(name_delete);
        $('#confirmModal').modal('show');
    });

    $(document).on('click', '.delete_submit', function(e) {
        e.preventDefault();
        var ids = $('#Delete_id').val();
        $('#confirmModal').modal('hide');

        $.ajax({
            url: '{{ route('dashboard.schools.delete') }}',
            method: 'POST',
            data: { "id": ids, "_token": "{{ csrf_token() }}" },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message, 'Success', { timeOut: 3000 });
                    $('#data-table').DataTable().ajax.reload(null, false);
                } else {
                    toastr.error(response.message, 'فشل العملية', { timeOut: 3000 });
                }
            },
            error: function(xhr) {
                toastr.error('هناك خطا ما يرجى المحاولة لاحقا', 'فشل العملية', { timeOut: 3000 });
            }
        });
    });
</script>
