@extends('layouts.master')
@section('main_title', 'الاعدادات العامة')
@section('main_page', 'اعدادات')
@section('title', 'اعدادات')
@section('content')

    <div id="kt_app_content_container" class="app-container container-fluid">
        <!--begin::Row-->
        <div class="row g-5 gx-xl-10 mb-5 mb-xl-10">

            <div class="card">
                <!--begin::Card header-->
                <div class="card-header border-0 pt-6">
                    <!--begin::Card title-->
                    <div class="card-title">
                        <!--begin::Search-->
                        <!--end::Search-->
                    </div>
                    <!--begin::Card title-->
                    <!--begin::Card toolbar-->
                    <div class="card-toolbar">
                        <!--begin::Toolbar-->

                        <!--end::Toolbar-->
                    </div>
                    <!--end::Card toolbar-->
                </div>
                <!--end::Card header-->

                <!--begin::Card body-->
                <div class="card-body pt-0">
                    <form action="{{route('dashboard.settings.update')}}" method="POST" enctype="multipart/form-data" id="my-form">
                        @csrf

                        <!-- Name Fields -->
                        <div class="row mb-4">
                            <div class="col-md-12">
                                <label for="name_ar" class="form-label">اسم الموقع <span class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-solid" id="name" name="name" value="{{settings('general','name')->value}}" required>
                                @error('name')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                        </div>

                        <!-- Description Fields -->
                        <div class="row mb-4">
                            <div class="col-md-12">
                                <label for="description" class="form-label">الوصف<span class="text-danger">*</span></label>
                                <textarea  name="description" class="tox-target kt_docs_tinymce_basic"> {{settings('general','description')->value}}</textarea>
                                @error('description')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror

                            </div>

                        </div>


                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label for="privacy_policy" class="form-label">سياسة الخصوصية<span class="text-danger">*</span></label>
                                <textarea  name="privacy_policy" class="form-control"> {{settings('privacy_policy','privacyPolicy')->value}}</textarea>
                                @error('privacy_policy')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror

                            </div>
                            <div class="col-md-6">
                                <label for="privacy_policy" class="form-label">الشروط والاحكام<span class="text-danger">*</span></label>
                                <textarea  name="term_condition" class="form-control"> {{settings('terms_and_conditions','termsConditions')->value}}</textarea>
                                @error('term_condition')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror

                            </div>

                        </div>

                        <div class="row mb-4">
                            <div class="col-md-6">
                                <label for="logo" class="form-label">الصورة الرئيسية</label>
                                <input type="file" class="form-control" id="logo" name="logo" onchange="previewImage(event)">
                                <div class="mb-3">
                                    <img id="image-preview" src="{{asset('storage/'.settings('general','logo')->value)}}" alt="Image Preview" style="max-width: 100px;">

                                </div>
                                @error('logo')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label for="cover_logo" class="form-label">الصورة الغلاف</label>
                                <input type="file" class="form-control form-control-solid" id="cover_logo" name="cover_logo" onchange="previewSecondaryImage(event)">
                                <div class="mb-3">
                                    <img id="secondary-image-preview" src="{{asset('storage/'.settings('general','coverLogo')->value)}}" alt="Image Preview" style="max-width: 100px;">
                                </div>
                                @error('cover_logo')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-4">

                        <div class="col-md-6">
                            <label for="icon_logo" class="form-label">صورة الايقونة</label>
                            <input type="file" class="form-control form-control-solid" id="icon_logo" name="icon_logo" onchange="previewThirtyImage(event)">
                            <div class="mb-3">
                                <img id="three-image-preview" src="{{asset('storage/'.settings('general','iconLogo')->value)}}" alt="Image Preview" style="max-width: 100px;">
                            </div>
                            @error('icon_logo')
                            <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        </div>




                        <!-- Submit Button -->
                        <div class="d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary">تاكيد</button>
                        </div>
                    </form>
                </div>
                <!--end::Card body-->
            </div>
        </div>
    </div>

@endsection

@section('scripts')
@include('dashboard.settings.js.general')
@endsection
