<script src="{{ asset('assets/plugins/custom/tinymce/tinymce.bundle.js') }}"></script>
<script src="{{ asset('assets/js/additional-methods.min.js') }}"></script>
<script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>

<script>
    var options = {selector: ".kt_docs_tinymce_basic", height : "480"};

    if ( KTThemeMode.getMode() === "dark" ) {
        options["skin"] = "oxide-dark";
        options["content_css"] = "dark";
    }

    tinymce.init(options);

    function previewImage(event) {
        const reader = new FileReader();
        reader.onload = function() {
            const output = document.getElementById('image-preview');
            output.src = reader.result;
            output.style.display = 'block';
        };
        reader.readAsDataURL(event.target.files[0]);
    }
    function previewSecondaryImage(event) {
        const secondaryReader = new FileReader();
        secondaryReader.onload = function() {
            const output = document.getElementById('secondary-image-preview');
            output.src = secondaryReader.result;
            output.style.display = 'block';
        };
        secondaryReader.readAsDataURL(event.target.files[0]);
    }
    function previewThirtyImage(event) {
        const secondaryReader = new FileReader();
        secondaryReader.onload = function() {
            const output = document.getElementById('three-image-preview');
            output.src = secondaryReader.result;
            output.style.display = 'block';
        };
        secondaryReader.readAsDataURL(event.target.files[0]);
    }

    $("#my-form").validate({
        rules: {
            name_ar: {
                required: true,
                maxlength: 255
            },
            name_en: {
                required: true,
                maxlength: 255
            },
            name_hi: {
                required: true,
                maxlength: 255
            },
            description_ar: {
                required: true,
            },
            description_en: {
                required: true,
            },
            description_hi: {
                required: true,
            }
            // Add other rules for additional fields as needed
        },
        messages: {
            name_ar: {
                required: "{{ __('messages.name_ar_required') }}",
                maxlength: "{{ __('messages.max_length_exceeded') }}"
            },
            name_en: {
                required: "{{ __('messages.name_en_required') }}",
                maxlength: "{{ __('messages.max_length_exceeded') }}"
            },
            name_hi: {
                required: "{{ __('messages.name_hi_required') }}",
                maxlength: "{{ __('messages.max_length_exceeded') }}"
            },
            description_ar: {
                required: "{{ __('messages.description_ar_required') }}"
            },
            description_en: {
                required: "{{ __('messages.description_en_required') }}"
            },
            description_hi: {
                required: "{{ __('messages.description_hi_required') }}"
            }
            // Add custom messages for additional fields as needed
        },
        submitHandler: function(form) {
            $('#spinner').show();
            $('#submit-button').prop('disabled', true);
            var url = $('#my-form').attr('action');
            $.ajax({
                url: url, // Update with your URL
                type: 'POST',
                data: new FormData(form),
                processData: false,
                contentType: false,
                beforeSend: function() {

                },
                success: function(response) {
                    // Hide the spinner and enable the submit button
                    $('#spinner').hide();
                    $('#submit-button').prop('disabled', false);

                    // Handle the response on success
                    if (response.success) {
                        toastr.success(response.message, 'Success', { timeOut: 3000 });
                        $('#kt_modal_branch-form').modal('hide');

                        window.location.reload();

                    } else {
                        toastr.error(response.message, 'Error', { timeOut: 3000 });

                    }
                },
                error: function(xhr) {
                    // Hide the spinner and enable the submit button
                    $('#spinner').hide();
                    $('#submit-button').prop('disabled', false);

                }
            });
        }

    });
</script>
