{{-- <script src="{{ asset('assets/js/jquery.min.js') }}"></script> --}}
<script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>
<script src="{{ asset('assets/js/additional-methods.min.js') }}"></script>
@if (app()->getLocale() === 'ar')
    <script src="https://cdn.jsdelivr.net/npm/jquery-validation@1.19.5/dist/localization/messages_ar.js"></script>
@endif
<script>
    $(document).ready(function() {
        // Reset form and hide previews when modal is closed
        $('#kt_modal_add_edit').on('hidden.bs.modal', function() {
            $('.error').text('');
            $('#add_edit_name').val('');
            $('#my-form')[0].reset();
        });


        $("#upload-form").validate({
            rules: {

                "excel_file": {
                    required: true,
                },
            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages

                $('#submit-button').prop('disabled',
                    true); // Disable submit button to prevent multiple submissions

                var url = $('#upload-form').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        $('#spinner').hide();
                        $('#kt_modal_upload_excel').modal('hide');

                        $('#upload-form')[0].reset();
                        if (response.success) {
                            toastr.success(response.message, 'Success');

                            $('#data-table').DataTable().ajax.reload(null, false);

                        } else {


                            if (response.errors) {
                                // Optional: Display validation errors
                                console.log('Validation Errors:', response.errors);
                            }

                            // If the response includes an error file, prompt download
                            if (response.download_url) {

                                // window.open(response.download_url, '_blank');
                                toastr.success(response.message, 'Success');

                                window.location.href = response.download_url;
                            }
                        }

                    },
                    error: function(xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            // Loop through the validation errors and display them with toastr
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                // Show the error messages in the corresponding fields
                                var errorContainer = $('#' + field + '_error');
                                errorContainer.text(messages.join(', '))
                                    .show(); // Join messages if there are multiple
                            });
                        } else {
                            // For other errors, display a general error message
                            toastr.error(
                                '{{ __('messages.An error occurred. Please try again later') }}',
                                'Error', {
                                    timeOut: 3000
                                });
                        }
                    }
                });
            }
        });

        $('#search_class_room_id').on('change', function() {
            table.draw();
        });
        $('#search_education_area_id').on('change', function() {
            table.draw();
        });
        // DataTable initialization
        var table = $('#data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('dashboard.students.getIndex') }}",
                data: function(d) {
                    d.search_education_area_id = $('#search_education_area_id').val();
                    d.search_class_room_id = $('#search_class_room_id').val();

                },
            },
            columns: [


                {
                    data: 'name',
                    name: 'name'
                },

                {
                    data: 'code',
                    name: 'code',
                },

                {
                    data: 'mobile',
                    name: 'mobile',
                },

                {
                    data: 'classRooms',
                    name: 'classRooms',
                },
                {
                    data: 'schools',
                    name: 'schools',
                },
                {
                    data: 'educationArea',
                    name: 'educationArea',
                },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
            ],
            order: [
                [1, 'desc']
            ]
        });

        // Search filter
        $('[data-kt-data-table-filter="search"]').on('keyup', function() {
            table.search(this.value).draw();
        });



        // Show modal if needed
        if ($('#show_modal').val()) {
            $('#kt_modal_add_edit').modal('show');
        }

        // Form validation and AJAX submit
        $('#my-form').validate({
            rules: {
                name: {
                    required: true,
                },

                education_area_id: {
                    required: true,

                },

                school_id: {
                    required: true,

                },
                governorate_id:{
                    required: true,

                },
                class_room_id: {
                    required: true,

                },
                password: {
                    required:function(){
                        return $('#add_edit_student_id').val()=='';
                    },

                },

            },
            submitHandler: function(form) {
                $('#spinner').show();
                $('.error').hide(); // Hide previous error messages
                $('#submit-button').prop('disabled',
                true); // Disable submit button to prevent multiple submissions

                var url = $('#my-form').attr('action');
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: new FormData(form),
                    processData: false,
                    contentType: false,
                    success: function(response) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        // Handle the response on success
                        if (response.success) {
                            toastr.success(response.message,
                                'نجاح العملية', {
                                    timeOut: 3000
                                });
                            $('#kt_modal_add_edit').modal('hide');
                            $('#data-table').DataTable().ajax.reload(null, false);
                        } else {
                            toastr.error(response.message, 'Error', {
                                timeOut: 3000
                            });
                        }
                    },
                    error: function(xhr) {
                        // Hide the spinner and enable the submit button
                        $('#spinner').hide();
                        $('#submit-button').prop('disabled', false);

                        if (xhr.status === 422) {
                            // Loop through the validation errors and display them with toastr
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(field, messages) {
                                // Show the error messages in the corresponding fields
                                var errorContainer = $('#' + field);
                                errorContainer.text(messages.join(', '))
                                    .show(); // Join messages if there are multiple
                            });
                        } else {
                            // For other errors, display a general error message
                            toastr.error(
                                'هناك خطا ما يرجى المحاولة لاحقا',
                                'فشل العملية', {
                                    timeOut: 3000
                                });
                        }
                    }
                });
            }
        });


        // Handle modal view and edit actions
        $(document).on('click', '.view, .edit', function() {
            const action = $(this).hasClass('view') ? 'view' : 'add_edit';
            const title = $(this).hasClass('view') ? 'عرض بيانات الطالب ' :
                'تعديل  بيانات الطالب';


            const form = $('#my-form'); // The form you want to set the action for


            // Set the action attribute of the form
            form.attr('action', "{{ route('dashboard.students.update') }}");

            const fields = [
                'educational_area_id',
                'name',
                'school_id',
                'class_room_id',
                'student_id',
                'governorate_id',
                'id_number',
                'class_section_id',
                'level_id',
                'mobile',



            ];

            fields.forEach(field => {
                $('#' + action + '_' + field).val($(this).data(field));
            });

            $('#add_edit_governorate_id').val($(this).data('governorate_id')).trigger('change.select2');
            $('#add_edit_class_room_id').val($(this).data('class_room_id')).trigger('change.select2');
            $('#add_edit_level_id').val($(this).data('level_id')).trigger('change.select2');
            getGovernorate($(this).data('governorate_id'),$(this).data('educational_area_id'))
            getEductionalArea($(this).data('educational_area_id'),$(this).data('school_id'))
            getClassSection($(this).data('class_room_id'),$(this).data('class_section_id'))



            $('.modal-title').text(title)
            $('#kt_modal_' + action).modal('show');
        });

        // Image preview functions


        // Bind preview functions to file input events

    });






    // Delete button click
    $(document).on('click', '.delete', function(e) {
        e.preventDefault();
        var name_delete = $(this).data('name_delete');
        var ids = $(this).data('id');
        $('#Delete_id').val(ids);
        $('#Name_Delete').val(name_delete);
        $('#confirmModal').modal('show');
    });
    // Confirm delete action
    $(document).on('click', '.delete_submit', function(e) {
        e.preventDefault();

        var ids = $('#Delete_id').val();
        $('#confirmModal').modal('hide');

        // Perform the AJAX delete request
        $.ajax({
            url: '{{ route('dashboard.students.delete') }}',
            method: 'POST',
            data: {
                "id": ids,
                "_token": "{{ csrf_token() }}"
            },
            success: function(response) {
                if (response.success) {
                    // Show success notification
                    toastr.success(response.message, 'Success', {
                        timeOut: 3000
                    });

                    // Reload the DataTable
                    $('#data-table').DataTable().ajax.reload(null, false);
                } else {
                    // Show error notification
                    toastr.error(response.message, 'فشل العملية', {
                        timeOut: 3000
                    });
                }
            },
            error: function(xhr) {
                // Hide the spinner and enable the submit button

                // For other errors, display a general error message
                toastr.error('هناك خطا ما يرجى المحاولى لاحقا',
                    'فشل العملية', {
                        timeOut: 3000
                    });


            }
        });
    });

    $(document).ready(function() {
        $('#add_edit_governorate_id').on('change', function() {
            let governorateId = $(this).val();
            getGovernorate(governorateId);
        });

        $('#add_edit_educational_area_id').on('change', function() {
            let educationalAreaId = $(this).val();
            getEductionalArea(educationalAreaId);

        });

        $('#add_edit_class_room_id').on('change', function() {
            let classRoomId = $(this).val();

            getClassSection(classRoomId);
        });

    });
        function getGovernorate(governorateId,educationalAreaId=null) {

            let $educationalArea = $('#add_edit_educational_area_id');

            $educationalArea.empty().append('<option value="">جاري التحميل...</option>');

            if (governorateId) {
                $.ajax({
                    url: "{{ route('getEducationalAreas') }}", // Your route to fetch educational areas
                    type: "GET",
                    data: {
                        governorate_id: governorateId
                    },
                    success: function(response) {
                        $educationalArea.empty().append(
                            '<option value="">اختر منطقة تعليمية</option>');
                        $.each(response, function(key, value) {
                            $educationalArea.append(
                            `<option value="${value.id}" ${value.id == educationalAreaId ? 'selected' : ''}>${value.name}</option>`
                        );



                        });
                    },
                    error: function() {
                        $educationalArea.empty().append('<option value="">فشل في التحميل</option>');
                    }
                });
            } else {
                $educationalArea.empty().append('<option value="">اختر منطقة تعليمية</option>');
            }
        }
        function getEductionalArea(educationalAreaId,schoolId=null) {
            let $school = $('#add_edit_school_id');

            $school.empty().append('<option value="">جاري التحميل...</option>');

            if (educationalAreaId) {
                $.ajax({
                    url: "{{ route('getShcools') }}", // Your route to fetch educational areas
                    type: "GET",
                    data: {
                        educational_area_id: educationalAreaId
                    },
                    success: function(response) {
                        $school.empty().append('<option value="">اختر المدرسة التعليمية</option>');
                        $.each(response, function(key, value) {
                            $school.append(
                                `<option value="${value.id}" ${value.id == schoolId ? 'selected' : ''}>${value.name}</option>`);
                        });
                    },
                    error: function() {
                        $school.empty().append('<option value="">فشل في التحميل</option>');
                    }
                });
            } else {
                $school.empty().append('<option value="">اختر المدرسة التعليمية</option>');
            }
        }

        function getClassSection(classRoomId,classSectionId=null) {
            let $classSection = $('#add_edit_class_section_id');

            $classSection.empty().append('<option value="">جاري التحميل...</option>');

            if (classRoomId) {
                $.ajax({
                    url: "{{ route('getSections') }}", // Your route to fetch educational areas
                    type: "GET",
                    data: {
                        class_room_id: classRoomId
                    },
                    success: function(response) {
                        $classSection.empty().append(
                            '<option value="">اختر الشعبة الدراسية</option>');
                        $.each(response, function(key, value) {

                                $classSection.append(
                                `<option value="${value.id}" ${value.id == classSectionId ? 'selected' : ''}>${value.name}</option>`);

                        });
                    },
                    error: function() {
                        $classSection.empty().append('<option value="">فشل في التحميل</option>');
                    }
                });
            } else {
                $classSection.empty().append('<option value="">اختر الشعبة الدراسية</option>');
            }
        }



</script>
