<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>سياسة الحذف</title>
    <style>
        /* عام */
body {
    font-family: Arial, sans-serif;
    direction: rtl;
    background-color: #f4f4f4;
    margin: 0;
    padding: 0;
}

.container {
    width: 80%;
    margin: 0 auto;
    padding: 20px;
    background-color: #fff;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
}

.header {
    text-align: center;
    margin-bottom: 20px;
}

.header h1 {
    font-size: 24px;
    color: #2c3e50;
}

.policy-content {
    line-height: 1.6;
    color: #34495e;
}

.policy-content h2 {
    font-size: 20px;
    color: #e74c3c;
}

.policy-content h3 {
    font-size: 18px;
    color: #2980b9;
    margin-top: 20px;
}

.policy-content ul {
    list-style-type: disc;
    margin-left: 20px;
}

.policy-content ul li {
    margin-bottom: 10px;
}

.policy-content p {
    font-size: 16px;
}

@media (max-width: 768px) {
    .container {
        width: 90%;
    }

    .header h1 {
        font-size: 20px;
    }

    .policy-content h2, .policy-content h3 {
        font-size: 16px;
    }
}

        </style>
</head>
<body>
    <section>
        <h2>🗑️ سياسة الحذف</h2>
        <p>نحن نحترم خصوصيتك ونعمل على منحك السيطرة الكاملة على بياناتك. وعليه، فإن سياسة الحذف لدينا تنص على ما يلي:</p>

        <h3>1. حذف الحساب</h3>
        <ul>
          <li>يمكن للمستخدم حذف حسابه في أي وقت من خلال إعدادات الحساب داخل التطبيق.</li>
          <li>عند حذف الحساب، يتم حذف جميع البيانات المرتبطة بالمستخدم بشكل دائم ونهائي ولا يمكن استعادتها.</li>
        </ul>

        <h3>2. حذف المحتوى</h3>
        <ul>
          <li>يحق للمستخدم حذف أي محتوى قام بنشره (مثل الصور، التعليقات، الطلبات، إلخ).</li>
          <li>بعض البيانات قد يتم الاحتفاظ بها لأغراض قانونية أو أمنية لفترة محدودة وفقًا للسياسات المعمول بها.</li>
        </ul>

        <h3>3. الحذف التلقائي</h3>
        <ul>
          <li>في حال عدم النشاط لفترة طويلة (مثلاً 12 شهرًا)، يحتفظ التطبيق بالحق في حذف الحساب بعد إرسال إشعار مسبق.</li>
        </ul>

        <h3>4. الاستثناءات</h3>
        <ul>
          <li>قد يتم الاحتفاظ ببعض البيانات لأغراض التحليل أو التوثيق أو الامتثال للمتطلبات القانونية، لكن يتم إزالتها من العرض العام.</li>
        </ul>

        <h3>5. طلب الحذف</h3>
        <ul>
          <li>يمكن للمستخدم تقديم طلب حذف يدوي عبر التواصل مع فريق الدعم عبر البريد الإلكتروني:
            <a href="mailto:support@example.com">support@example.com</a>
          </li>
        </ul>
      </section>

</body>
</html>
