<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>سياسة الخصوصية</title>
    <style>
        /* عام */
body {
    font-family: Arial, sans-serif;
    direction: rtl;
    background-color: #f4f4f4;
    margin: 0;
    padding: 0;
}

.container {
    width: 80%;
    margin: 0 auto;
    padding: 20px;
    background-color: #fff;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
}

.header {
    text-align: center;
    margin-bottom: 20px;
}

.header h1 {
    font-size: 24px;
    color: #2c3e50;
}

.policy-content {
    line-height: 1.6;
    color: #34495e;
}

.policy-content h2 {
    font-size: 20px;
    color: #e74c3c;
}

.policy-content h3 {
    font-size: 18px;
    color: #2980b9;
    margin-top: 20px;
}

.policy-content ul {
    list-style-type: disc;
    margin-left: 20px;
}

.policy-content ul li {
    margin-bottom: 10px;
}

.policy-content p {
    font-size: 16px;
}

@media (max-width: 768px) {
    .container {
        width: 90%;
    }

    .header h1 {
        font-size: 20px;
    }

    .policy-content h2, .policy-content h3 {
        font-size: 16px;
    }
}

        </style>
</head>
<body>
    <div class="container">
        <header class="header">
            <h1>سياسة الخصوصية لتطبيق كانجاروا فلسطين للمسابقات التعليمية</h1>
        </header>

        <section class="policy-content">
            <h2>تاريخ السريان: 01-04-2026</h2>
            <p>نحن في تطبيق "كانجاروا فلسطين للمسابقات التعليمية" (المشار إليه فيما بعد بـ "التطبيق" أو "نحن") نلتزم بحماية خصوصيتك وبياناتك الشخصية. توضح سياسة الخصوصية هذه كيفية جمع واستخدام وحماية البيانات الشخصية للمستخدمين الذين يستخدمون التطبيق.</p>

            <h3>1. المعلومات التي نجمعها</h3>
            <ul>
                <li><strong>المعلومات الأساسية:</strong> الاسم، البريد الإلكتروني، رقم الهاتف، .</li>
                <li><strong>المعلومات المتعلقة بالمشاركة:</strong> نتائج المسابقات، الدرجات، المشاركات السابقة.</li>
            </ul>

            <h3>2. كيفية استخدامنا للبيانات</h3>
            <p>نستخدم المعلومات التي نجمعها للأغراض التالية:</p>
            <ul>
                <li>لتحسين تجربة المستخدم داخل التطبيق.</li>
                <li>لإدارة المسابقات وتقديم النتائج والتقييمات.</li>
                <li>لإرسال إشعارات أو رسائل تتعلق بالتطبيق.</li>
                <li>لتحليل سلوك المستخدم وتحسين الأداء.</li>
            </ul>

            <h3>3. مشاركة البيانات</h3>
            <p>نحن لا نشارك معلوماتك الشخصية مع أي أطراف ثالثة إلا في الحالات التالية:</p>
            <ul>
                <li>إذا كان هناك التزام قانوني أو تنظيمي يتطلب منا الكشف عن معلوماتك.</li>
                <li>إذا كان ذلك ضروريًا لتقديم الخدمة لك، مثل توفير الدعم الفني.</li>
            </ul>

            <h3>4. حماية البيانات</h3>
            <p>نحن نتخذ تدابير أمنية معقولة لحماية بياناتك الشخصية من الوصول غير المصرح به أو التلاعب أو الفقدان. يتم تخزين البيانات باستخدام تقنيات حديثة لضمان الحفاظ على سريتها.</p>

            <h3>5. حقوقك</h3>
            <p>يحق لك في أي وقت:</p>
            <ul>
                <li>الوصول إلى بياناتك الشخصية وتصحيحها أو تحديثها.</li>
                <li>حذف حسابك أو سحب موافقتك على معالجة بياناتك الشخصية.</li>
                <li>طلب معلومات حول كيفية استخدام بياناتك.</li>
            </ul>

            <h3>6. التغييرات في سياسة الخصوصية</h3>
            <p>نحتفظ بالحق في تعديل هذه السياسة في أي وقت. سيتم إعلامك بأي تغييرات جوهرية عبر التطبيق أو من خلال البريد الإلكتروني.</p>

            <h3>7. الاتصال بنا</h3>
            <p>إذا كانت لديك أي أسئلة أو استفسارات حول سياسة الخصوصية هذه أو كيفية التعامل مع بياناتك، يمكنك التواصل معنا عبر:</p>
            <ul>
                <li>رقم الهاتف: +972 59-909-2007</li>
                <li>العنوان: غزة -فلسطين</li>
            </ul>
        </section>
    </div>
</body>
</html>
