<script src="{{ asset('assets/js/additional-methods.min.js') }}"></script>
<script src="{{ asset('assets/js/jquery.validate.min.js') }}"></script>

<script>
    $(document).ready(function() {
        // Reset form and modal previews when modal is hidden
        $('#kt_modal_infraction-form').on('hidden.bs.modal', function () {
            $('.error').text('');

            resetForm();
        });

        // Initialize DataTable
        var table = $('#data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('dashboard.governorates.getIndex') }}",
            columns: [
                { data: 'name', name: 'name' },
                { data: 'is_active', name: 'is_active' },
                { data: 'actions', name: 'actions', orderable: false, searchable: false }
            ],
            order: [[1, 'desc']]
        });

        // Search filter
        $('[data-kt-data-table-filter="search"]').on('keyup', function () {
            table.search(this.value).draw();
        });

        // Show modal if necessary
        let show_modal = $('#show_modal').val();
        if (show_modal) {
            $('#kt_modal_infraction-form').modal('show');
        }
    });
    // Reset form fields and preview images
    function resetForm() {
        $('#my-form')[0].reset();
        $('#is-active').prop('checked',true);


    }
    $('#my-form').validate({
        rules: {
            name: { required: true },
        },

        submitHandler: function(form) {
            $('#spinner').show();
            $('#submit-button').prop('disabled', true);
            var url = $('#my-form').attr('action');
            $.ajax({
                url: url, // Update with your URL
                type: 'POST',
                data: new FormData(form),
                processData: false,
                contentType: false,
                beforeSend: function() {

                },
                success: function(response) {
                    // Hide the spinner and enable the submit button
                    $('#spinner').hide();
                    $('#submit-button').prop('disabled', false);

                    // Handle the response on success
                    if (response.success) {
                        toastr.success(response.message, 'Success', { timeOut: 3000 });
                        $('#kt_modal_add_edit').modal('hide');
                        $('#data-table').DataTable().ajax.reload();


                    } else {
                        toastr.error(response.message, 'Error', { timeOut: 3000 });

                    }
                },
                error: function(xhr) {
                    // Hide the spinner and enable the submit button
                    $('#spinner').hide();
                    $('#submit-button').prop('disabled', false);

                }
            });
        }
    });
    // View button click
    $(document).on('click', '.view', function() {
        // Extract data from data-* attributes
        const data = $(this).data();

        // Populate modal fields
        $('#name').val(data.name);

        // Show the modal
        $('#kt_modal_view').modal('show');
    });
    // Edit button click
    $(document).on('click', '.edit', function() {
        const data = $(this).data();

        $('.show_active').show();
        $('.modal-title').text('{{__('messages.edit_infraction')}}')
        $('#edit_name').val(data.name);
        $('#governorate_id').val(data.id);
        $('#is-active').prop('checked', data.is_active);
        $('#my-form').attr('action', "{{ route('dashboard.governorates.update') }}");
        $('#kt_modal_add_edit').modal('show');
    });
    // Delete button click
    $(document).on('click', '.delete', function(e) {
        e.preventDefault();
        var name_delete = $(this).data('name_delete');
        var ids = $(this).data('id');
        $('#Delete_id').val(ids);
        $('#Name_Delete').val(name_delete);
        $('#confirmModal').modal('show');
    });
    // Confirm delete action
    $(document).on('click', '.delete_submit', function(e) {
        e.preventDefault();

        var ids = $('#Delete_id').val();
        $('#confirmModal').modal('hide');

        // Perform the AJAX delete request
        $.ajax({
            url: '{{ route('dashboard.governorates.delete') }}',
            method: 'POST',
            data: {
                "id": ids,
                "_token": "{{ csrf_token() }}"
            },
            success: function(response) {
                if (response.success) {
                    // Show success notification
                    toastr.success(response.message, 'Success', { timeOut: 3000 });

                    // Reload the DataTable
                    $('#data-table').DataTable().ajax.reload();
                } else {

                    // Show error notification
                    toastr.error(response.message, 'Error', { timeOut: 3000 });
                }
            },
            error: function() {
                // Show general error notification
                toastr.error('An error occurred. Please try again later.', 'Error', { timeOut: 3000 });
            }
        });
    });

</script>


