<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}" id="main-html" data-locale="{{ app()->getLocale() }}">
<!--begin::Head-->

<head>
    <base href="">
    <title>{{setting('name')}} - {{@$title}}</title>
    <meta charset="utf-8"/>
    <meta name="description"
          content="{{setting('description')}}"/>
    <meta name="keywords"
          content="Metronic, bootstrap, bootstrap 5, Angular, VueJs, React, Laravel, admin themes, web design, figma, web development, free templates, free admin themes, bootstrap theme, bootstrap template, bootstrap dashboard, bootstrap dak mode, bootstrap button, bootstrap datepicker, bootstrap timepicker, fullcalendar, datatables, flaticon"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <meta property="og:locale" content="en_US"/>
    <meta property="og:type" content="article"/>
    <meta property="og:title"
          content="{{setting('welcome')}} | {{setting('name')}}"/>
    <meta property="og:url" content="{{url('')}}"/>
    <meta property="og:site_name" content="{{setting('welcome')}} | {{setting('name')}}"/>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link href="{{ asset('vendor/toastr/toastr.min.css') }}" rel="stylesheet">

    {{-- @include('layouts.css') --}}

    <!--end::Global Stylesheets Bundle-->
    @livewireStyles
    <script src="https://cdn.jsdelivr.net/npm/@hotwired/turbo@7.0.0/dist/turbo.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

</head>
<!--end::Head-->

<!--begin::Body-->

<body id="kt_body" lang="{{App::getLocale()}}"
      class="header-fixed header-tablet-and-mobile-fixed toolbar-enabled toolbar-fixed aside-enabled aside-fixed"
      style="--kt-toolbar-height:55px;--kt-toolbar-height-tablet-and-mobile:55px">
<!--begin::Main-->
<!--begin::Root-->
<div class="d-flex flex-column flex-root">
    <!--begin::Page-->
    <div class="page d-flex flex-row flex-column-fluid">
        <!--begin::Aside-->
        @if (session('message'))
            <script>
                toastr.success("{{ session('message') }}");
            </script>
        @endif
        @include('layouts.aside')

        <!--end::Aside-->
        <!--begin::Wrapper-->
        <div class="wrapper d-flex flex-column flex-row-fluid" id="kt_wrapper">
            <!--begin::Header-->
            @include('layouts.header')
            <!--end::Header-->
            <!--begin::Content-->
            <div class="content d-flex flex-column flex-column-fluid" id="kt_content">
                <!--begin::Toolbar-->
                <div class="toolbar" id="kt_toolbar">
                    <!--begin::Container-->
                    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
                        <!--begin::Page title-->
                        <div data-kt-swapper="true" data-kt-swapper-mode="prepend"
                             data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}"
                             class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
                            <!--begin::Title-->
                            <h1 class="d-flex text-dark fw-bolder fs-3 align-items-center my-1">{{setting('name')}}
                                <!--begin::Separator-->
                                <span class="h-20px border-1 border-gray-200 border-start ms-3 mx-2 me-1"></span>
                                <!--end::Separator-->
                                <!--begin::Description-->
                                <span class="text-muted fs-7 fw-bold mt-2">{{@$title}}</span>
                                <!--end::Description-->
                            </h1>
                            <!--end::Title-->
                        </div>

                    </div>
                    <!--end::Container-->
                </div>
                <!--end::Toolbar-->
                <!--begin::Post-->


                @yield('content')
                {{-- {{$slot}} --}}
                <!--end::Post-->
            </div>
            <!--end::Content-->
            <!--begin::Footer-->
            <div class="footer py-4 d-flex flex-lg-column" id="kt_footer">
                <!--begin::Container-->
                <div
                    class="container-fluid d-flex flex-column flex-md-row align-items-center justify-content-between">
                    <!--begin::Copyright-->
                    <div class="text-dark order-2 order-md-1">
                        <span class="text-muted fw-bold me-1">{{date('Y')}}©</span>
                        <a href="https://keenthemes.com" target="_blank"
                           class="text-gray-800 text-hover-primary">{{setting('footer_text')}}</a>
                    </div>
                    <!--end::Copyright-->

                </div>
                <!--end::Container-->
            </div>
            <!--end::Footer-->
        </div>
        <!--end::Wrapper-->
    </div>
    <!--end::Page-->
</div>
<!--end::Root-->
<!--begin::Drawers-->


@include('layouts.js')
<script src="{{ asset('vendor/toastr/toastr.min.js') }}"></script>

<!--end::Page Custom Javascript-->
<!--end::Javascript-->
@livewireScripts
{{--<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>--}}

<script>

    document.addEventListener('livewire:load', function () {
        // Listen for the 'governorate-saved' event

            toastr.success('تم تنفيد العملية بنجاح');


    });
    function handleLocaleChange(locale) {
        // Update the `dir` attribute on the main HTML element
        document.getElementById('main-html').setAttribute('dir', locale === 'ar' ? 'rtl' : 'ltr');
        htmlTag.setAttribute('lang', locale);

        // Update CSS based on locale
        const cssLink = document.querySelector('link[href*="style.bundle"]');
        if (cssLink) {
            // Update the href attribute to point to the correct stylesheet
            cssLink.href = locale === 'ar'
                ? '{{ url('dashboard/assets/css/style.bundle.rtl.css') }}'
                : '{{ url('dashboard/assets/css/style.bundle.css') }}';
        }

        // Apply Toastr RTL styles if needed
        document.querySelectorAll('.toast').forEach(toast => {
            if (locale === 'ar') {
                toast.classList.add('toast-rtl');
            } else {
                toast.classList.remove('toast-rtl');
            }
        });
    }

    // Listen for Livewire event
    Livewire.on('localeChanged', (locale) => {
        console.log(locale);
        // Assuming locale is passed as a string directly, not an array
        // console.log(locale);
        handleLocaleChange(locale);
    });

    const currentLocale = document.getElementById('main-html').getAttribute('data-locale');
    handleLocaleChange(currentLocale);
</script>
</body>
<!--end::Body-->


</html>
