<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <base href="../../../">
    <title>{{__('label.forget_password')}}</title>
    <meta charset="utf-8"/>
    <meta name="description" content="Setting not found"/>
    <meta name="keywords" content="{{__('label.forget_password')}}"/>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <meta property="og:locale" content="en_US"/>
    <meta property="og:type" content="article"/>
    <meta property="og:title" content="نصنع الأمل"/>
    <meta property="og:url" content="https://taqat-gaza.com"/>
    <meta property="og:site_name" content="طاقات | نصنع الأمل"/>
    <link rel="canonical" href="{{url('/')}}"/>
    <link rel="shortcut icon" href="{{setting('logo')}}"/>
    <!--begin::Fonts-->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700"/>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@700&display=swap" rel="stylesheet">
    <!--end::Fonts-->
    <!--begin::Global Stylesheets Bundle(used by all pages)-->
    <link href="{{asset('dashboard/assets/css/style.bundle.rtl.css')}}" rel="stylesheet" type="text/css"/>
    <script src="{{asset('dashboard/assets/plugins/global/plugins.bundle.js')}}"></script>

    <style>
        h1, * {
            font-family: "Tajawal", sans-serif;
        }

        .error-msg, .error-update {
            color: red;
            font-size: 12px;
            margin-top: 5px;
        }

        .form-container {
            display: none;
        }

        .form-container.active {
            display: block;
        }

        * {
            direction: rtl;
            font-family: "Tajawal", sans-serif;
        }
    </style>
</head>
<body id="kt_body" class="bg-body">
<!--begin::Main-->
<!--begin::Root-->
<div class="d-flex flex-column flex-root">
    <!--begin::Authentication - Sign-in -->
    <div class="d-flex flex-column flex-column-fluid bgi-position-y-bottom position-x-center bgi-no-repeat bgi-size-contain bgi-attachment-fixed">
        <!--begin::Content-->
        <div class="d-flex flex-center flex-column flex-column-fluid p-10 pb-lg-20">
            <!--begin::Logo-->
            <a href="#" class="mb-12">
                <img alt="Logo" src="https://taqat-gaza.com/uploads/images/settings//I99I9XyqKRi8w5sW.png" class="h-80px"/>
            </a>

            <div id="error-alert" class="alert alert-danger alert-dismissible fade show" role="alert" style="display: none;">
                <!--begin::Close-->
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                <!--end::Close-->

                <!--begin::Content-->
                <div id="error-messages"></div>
                <!--end::Content-->
            </div>
            <!--end::Logo-->

            <!--begin::Wrapper-->
{{$slot}}}
            <!--end::Wrapper-->
        </div>
        <!--end::Content-->
    </div>
    <!--end::Authentication - Sign-in-->
</div>
<!--end::Root-->

<!--begin::Javascript-->
<script src="{{asset('dashboard/assets/plugins/global/plugins.bundle.js')}}"></script>
<script src="{{asset('dashboard/assets/js/scripts.bundle.js')}}"></script>


</body>
</html>

