<div>
    <!-- Displaying Session Error Message -->
    @if (session()->has('error'))
        <div class="alert alert-danger mt-3">
            {{ session('error') }}
        </div>
    @endif

    <!-- Login Form -->
    <form wire:submit.prevent="login" class="form w-100" novalidate="novalidate">
        <!-- Email Input -->
        <div class="fv-row mb-10">
            <label class="form-label fs-6 fw-bolder text-dark">Email</label>
            <input type="email" class="form-control form-control-lg form-control-solid" wire:model="email" placeholder="Enter your email" />
            @error('email')
            <span class="text-danger d-block mt-2">{{ $message }}</span>
            @enderror
        </div>

        <!-- Password Input -->
        <div class="fv-row mb-10">
            <label class="form-label fs-6 fw-bolder text-dark">Password</label>
            <input type="password" class="form-control form-control-lg form-control-solid" wire:model="password" placeholder="Enter your password" />
            @error('password')
            <span class="text-danger d-block mt-2">{{ $message }}</span>
            @enderror
        </div>

        <!-- Submit Button -->
        <div class="text-center">
            <button type="submit" class="btn btn-lg btn-primary w-100">
                Login
                <!-- Optionally, add a loading indicator -->
                <!-- <span wire:loading>
                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                </span> -->
            </button>
        </div>
    </form>


</div>
