<div id="kt_content_container" class="container-xxl" xmlns="http://www.w3.org/1999/html">
    <!--begin::Card-->
    <div class="card">
        <!--begin::Card header-->
        <div class="card-header border-0 pt-6">
            <!--begin::Card title-->
            <div class="card-title">
            عرض كافة فصول المادة الدراسية
            </div>
            <!--begin::Card title-->
            <!--begin::Card toolbar-->
            <div class="card-toolbar">
                <!--begin::Toolbar-->
                <div class="d-flex justify-content-end" data-kt-customer-table-toolbar="base">
                    <!--begin::Filter-->

                    @if(auth('admin')->user()->can('add_chapter'))
                    <button type="button"  wire:click="openModal" class="btn btn-primary" data-bs-toggle="modal">اضافة وحدة دراسية جديدة</button>
                    @endif
                    <!--end::Add customer-->
                </div>
                <!--end::Toolbar-->
                <!--begin::Group actions-->
                <div class="d-flex justify-content-end align-items-center d-none" data-kt-customer-table-toolbar="selected">
                    <div class="fw-bolder me-5">
                        <span class="me-2" data-kt-customer-table-select="selected_count"></span>Selected</div>
                    <button type="button" class="btn btn-danger" data-kt-customer-table-select="delete_selected">Delete Selected</button>
                </div>
                <!--end::Group actions-->
            </div>
            <!--end::Card toolbar-->
        </div>
        <!--end::Card header-->
        <!--begin::Card body-->
        <div class="card-body pt-0">
            <div class="row">

                <div class="col-sm-12 col-lg-2" style="float:right">
                    <div>
                        <label for="per_page">اظهار</label>
                        <select wire:model.live.debounce.250ms="perPage"
                            class=" custom-select form-control form-control form-control-sm d-inline w-auto form-select form-select-sm form-select-solid">
                            <option value="10">10</option>
                            <option value="20">20</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                            <option value="250">250</option>
                        </select>
                        <label for="per_page">عرض</label>

                    </div>

                </div>
                <div class="col-sm-12 col-lg-3">

                    <div class="d-flex align-items-center position-relative" >
                        <select name="search_class_room_id"
                                wire:model="search_class_room_id" wire:change="onClassRoomChange"
                        class="form-select form-select-solid form-control form-control-solid w-350px ps-15"
                       data-placeholder="اختر">
                        <option value="">كافة المراحل التعليمية</option>
                              @foreach($classRooms as $value)
                                <option value="{{$value->id}}">{{$value->name}}</option>
                            @endforeach
                            </select>
                    </div>

                </div>
                <div class="col-sm-12 col-lg-3">


                    <!-- Material Selection -->
                    <div class="d-flex align-items-center position-relative my-1 " style="margin-right: 2%">
                        <select name="search_material_id"
                                wire:model.live.debounce.250ms="search_material_id"
                                class="form-select form-select-solid w-250px ps-15"
                                aria-label="Select Material">
                            <option value="">كافة المواد التعليمية</option>
                            @foreach($search_materials as $value)
                                <option value="{{ $value->id }}">{{ $value->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>


                <div class="col-sm-12 col-lg-3" style="float:left">
                    <div class="d-flex align-items-center position-relative my-1">
                        <!--begin::Svg Icon | path: icons/duotune/general/gen021.svg-->
                        <span class="svg-icon svg-icon-1 position-absolute ms-6">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                fill="none">
                                <rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2"
                                    rx="1" transform="rotate(45 17.0365 15.1223)" fill="currentColor" />
                                <path
                                    d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z"
                                    fill="currentColor" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                        <input type="text" wire:model.live.debounce.250ms="search"
                            class="form-control form-control-solid w-250px ps-15" placeholder="Search" />
                    </div>

                </div>
            </div>
            <table class="table align-middle table-row-dashed fs-6 gy-5">
                <thead>
                <tr>
                    <th  class="min-w-125px" wire:click="sortBy('name')" style="cursor: pointer;">
                        الوحدة الدراسية
                        @if($sortField === 'name')
                            <i class="fa fa-sort-{{ $sortDirection }}"></i>
                        @endif
                    </th>
                    <th   class="min-w-125px">عنوان الوحدة</th>

                    <th   class="min-w-125px">المرحلة الدراسية</th>
                    <th   class="min-w-125px">المادة الدراسية</th>
                    <th   class="min-w-125px">عدد الدروس</th>
                    <th   class="min-w-125px">الحالة</th>
                    @if(auth('admin')->user()->can('edit_chapter')||auth('admin')->user()->can('delete_chapter'))

                    <th   class="min-w-125px">العمليات</th>
                    @endif
                </tr>
                </thead>
                <tbody>
                @foreach($chapters as $value)
                    <tr>
                        <td>{{ $value->name }}</td>

                        <td>{{ $value->title }}</td>

                        <td>{{ $value->classRooms?$value->classRooms->name :'' }}</td>
                        <td>{{ $value->materials?$value->materials->name :'' }}</td>

                        <td>      <button wire:click="openModalLesson({{ $value->id }})" class="btn btn-default btn-sm">

                                {{$value->numberOfLessons()}}
                            </button>
                        </td>
                        <td>{!! $value->getStatus() !!} </td>
                        <td>
                            @if(auth('admin')->user()->can('display_lessons'))
                            <button wire:click="openModalLesson({{ $value->id }})" class="btn btn-secondary btn-sm" title="عرض الدروس التعليمة">
                                <i class="fa-solid fa-list"></i>
                            </button>
                            @endif
                                @if(auth('admin')->user()->can('add_lesson'))

                                <button wire:click="openModalAddLesson({{ $value->id }})" class="btn btn-success btn-sm" title="اضافة درس تعليمي جديد">
                                <i class="fa-solid fa-plus"></i>
                            </button>
                                @endif

                                @if(auth('admin')->user()->can('edit_chapter'))


                            <button wire:click="openModal({{ $value->id }})" class="btn btn-primary btn-sm" title="تعديل الوحدة التعليمية">
                                <i class="fa fa-edit"></i>
                            </button>
                                @endif

                                @if(auth('admin')->user()->can('edit_chapter'))

                                <button wire:click="confirmDelete({{ $value->id }})" class="btn btn-danger btn-sm" title="حذف الوحدة التعليمية">
                                <i class="fa fa-trash"></i>
                                    @endif
                            </button>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>

            <!-- Pagination Links -->
            <div class="mt-4">
                {{ $chapters->links('vendor.livewire.bootstrap') }}
            </div>
        </div>
    </div>

    <!-- Modal for Edit/Create Governorate -->
    @if($isModalOpen)
        <div class="modal fade @if($isModalOpen) show @endif" tabindex="-1" role="dialog" aria-labelledby="modalLabel" @if($isModalOpen) style="display: block;" @endif aria-modal="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalLabel">{{ $chapterId ? 'تعديل بيانات الوحدة' : 'اضافة بيانات الوحدة' }}</h5>
                        <button type="button" class="btn-close" wire:click="closeModal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form wire:submit.prevent="save">


                            <div class="form-group mb-3 row">
                                <div class="col-lg-6 col-sm-12">
                                    <label for="name" class="form-label">

                                        الكود
                                        <span class="required"></span>
                                    </label>
                                    <input type="text" id="name" wire:model="name" class="form-control form-control-solid">
                                    @error('name')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                </div>
                                <div class="col-lg-6 col-sm-12">
                                    <label for="name" class="form-label">

                                        عنوان الوحدة
                                        <span class="required"></span>
                                    </label>
                                    <input type="text" id="title" wire:model="title" class="form-control form-control-solid">
                                    @error('title')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                </div>


                            </div>

                            <div class="form-group mb-3 row">
                                <div class="col-lg-12 col-sm-12">

                                <label for="description" class="form-label">

                                    الوصف
                                    <span class="required"></span>
                                </label>
                                <textarea  id="description" wire:model="description" class="form-control form-control-solid"></textarea>
                                @error('description')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            </div>

                            <div class="form-group mb-3 row">
                                <div class="col-lg-6 col-sm-12">
                                    <label for="classRoomId" class="form-label">

                                        المرحلة الدراسية
                                        <span class="required"></span>
                                    </label>
                                    <select class="form-select select2-container" data-control="select2" name="classRoomId" id="classRoomId" wire:model="classRoomId" wire:change="onClassRoomChange">

                                        <option value="">اختر</option>
                                        @foreach($classRooms as $value)
                                            <option value="{{ $value->id }}" @if($value->id == $classRoomId) selected @endif>{{ $value->name }}</option>
                                        @endforeach
                                    </select>

                                    @error('classRoomId')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                </div>

                                <div class="col-lg-6 col-sm-12">

                                <label for="materialId" class="form-label">
                                    المادة الدراسية
                                    <span class="required"></span>
                                </label>
                                <select class="form-select select2-container" name="materialId" id="materialId" wire:model="materialId">
                                    <option value="">اختر</option>
                                    @foreach($materials as $material)
                                        <option value="{{ $material->id }}" @if($material->id == $materialId) selected @endif>{{ $material->name }}</option>
                                    @endforeach
                                </select>

                                @error('materialId')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror

                            </div>



                            </div>



                            <div class="form-group mb-3">
                                <label for="status">الحالة</label>
                                <div class="form-check form-switch">


                                    <input class="form-check-input"  @if($status == 1) checked @endif type="checkbox" value="1" wire:model="status" id="status" />
                                </div>
                            </div>







                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary btn-sm"> <i class="fa fa-paper-plane"></i>تاكيد</button>

                                <button type="button" class="btn btn-secondary btn-sm" wire:click="closeModal">الغاء</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        @if($isModalOpen)
            <div class="modal-backdrop fade show"></div>
        @endif
    @endif

        @if($isLessonModalOpen)
            <div class="modal fade show" tabindex="-1" role="dialog" aria-labelledby="modalLabel" style="display: block;" aria-modal="true">
                <div class="modal-dialog modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalLabel">قائمة الدروس التعليمية</h5>
                            <button type="button" class="btn-close" wire:click="closeLessonModal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">


                            <table class="table align-middle table-row-dashed fs-6 gy-5">
                                <thead>
                                <tr>
                                    <th      class="min-w-125px">الاسم</th>
                                    <th   class="min-w-125px">الوحدة الدراسية</th>
                                    <th   class="min-w-125px">المادة الدراسية</th>

                                    <th   class="min-w-125px">العمليات</th>
                                    <th   class="min-w-125px">
                                    <button wire:click="openModalAddLesson({{ $value->id }})" class="btn btn-success btn-sm">
                                        <i class="fa-solid fa-plus"></i> اضافة درس تعليمي  جديد
                                    </button>
                                    </th>
                                </tr>


                                </thead>
                                <tbody>
                                @foreach($lessons as $index => $value)

                                    <tr>

                                        <td class="min-w-125px"> <?php echo $value->name  ?></td>
                                        <td class="min-w-125px">{{ $value->chapters?$value->chapters->name :'' }}</td>
                                        <td class="min-w-125px"> {{ $value->chapters?$value->chapters->materials?$value->chapters->materials->name :'':'' }}</td>
                                        <td class="min-w-125px">

                                            <button wire:click="openEditLessonModal({{ $value->id }})" class="btn btn-primary btn-sm">
                                                <i class="fa fa-edit"></i> تعديل
                                            </button>
                                            <button wire:click="confirmLessonDelete({{ $value->id }})" class="btn btn-danger btn-sm">
                                                <i class="fa fa-trash"></i> حذف
                                            </button>
                                        </td>

                                    </tr>



                                @endforeach

                                </tbody>

                            </table>



                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-backdrop fade show"></div>
        @endif







    @if($isAddLessonModalOpen)
        <div class="modal fade show" tabindex="-1" role="dialog" aria-labelledby="modalLabel" style="display: block;" aria-modal="true">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalLabel">اضافة الدروس التعليمية</h5>
                        <button type="button" class="btn-close" wire:click="closeAddLessonModal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form wire:submit.prevent="saveLesson">


                            <div class="form-group mb-3 row">

                                <div class="col-lg-6 col-sm-12">
                                    <label for="name" class="form-label">

                                        كود
                                        <span class="required"></span>
                                    </label>
                                    <input type="text" id="lesson_code" wire:model="lesson_code" class="form-control form-control-solid">
                                    @error('lesson_code')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                </div>
                                <div class="col-lg-6 col-sm-12">
                                    <label for="name" class="form-label">

                                        الاسم
                                        <span class="required"></span>
                                    </label>
                                    <input type="text" id="name" wire:model="lesson_name" class="form-control form-control-solid">
                                    @error('lesson_name')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                </div>


                            </div>

                            <div class="form-group mb-3 row">
                                <div class="col-lg-12 col-sm-12">

                                    <label for="description" class="form-label">

                                        الوصف
                                        <span class="required"></span>
                                    </label>
                                    <textarea  id="description" wire:model="lesson_description" class="form-control form-control-solid"></textarea>
                                    @error('lesson_description')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>



                            <div class="form-group mb-3 row">
                                <div class="col-lg-6 col-sm-12">
                                    <label for="video" class="form-label">إرفاق فيديو</label>
                                    <input type="text" id="video" wire:model="attachment" class="form-control form-control-solid">
                                    @error('attachment')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror

{{--                                    <!-- Display loading state -->--}}
{{--                                    <div wire:loading wire:target="attachment">--}}
{{--                                        <progress max="100" x-bind:value="progress"></progress> <span>Uploading Video...</span>--}}
{{--                                    </div>--}}

                                    <!-- Display video preview only when the upload is complete -->
                                    <div wire:loading.remove wire:target="attachment">
{{--                                        @if ($attachment)--}}

{{--                                            <video width="100%" controls class="m-1" style="width: 150px; height: 150px">--}}
{{--                                                <source src="{{ $attachment->temporaryUrl() }}" type="video/mp4" style="width: 150px; height: 150px">--}}
{{--                                                متصفحك لا يدعم تشغيل الفيديو.--}}
{{--                                            </video>--}}
                                            @if ($existingVideoPath)

                                            <video width="100%" controls class="m-1" style="width: 150px; height: 150px">
                                                <source src="{{ asset('storage/' . $existingVideoPath) }}" type="video/mp4">
                                                متصفحك لا يدعم تشغيل الفيديو.
                                            </video>
                                        @endif



                                    </div>
                                </div>

                                <!-- Cover Image Upload -->
{{--                                <div class="col-lg-6 col-sm-12">--}}
{{--                                    <label for="cover_attachment" class="form-label">إرفاق صورة غلاف</label>--}}
{{--                                    <input type="file" id="cover_attachment" wire:model="cover_attachment" class="form-control form-control-solid">--}}

{{--                                    <!-- Display loading state for image -->--}}
{{--                                    <div wire:loading wire:target="cover_attachment">--}}
{{--                                        <progress max="100" x-bind:value="progress"></progress> <span>Uploading Image...</span>--}}
{{--                                    </div>--}}

{{--                                    @error('cover_attachment')--}}
{{--                                        <span class="text-danger">{{ $message }}</span>--}}
{{--                                    @enderror--}}

{{--                                    <!-- Display image preview only when the upload is complete -->--}}
{{--                                    <div wire:loading.remove wire:target="cover_attachment">--}}
{{--                                        @if ($cover_attachment)--}}
{{--                                            <img src="{{ $cover_attachment->temporaryUrl() }}" alt="Cover Image" class="m-1" style="width: 240px; height: 240px">--}}
{{--                                            @elseif ($existingCoverPath)--}}
{{--                                            <video width="100%" controls class="m-1" style="width: 150px; height: 150px">--}}
{{--                                                <source src="{{ asset('storage/' . $existingCoverPath) }}" type="video/mp4">--}}
{{--                                                متصفحك لا يدعم تشغيل الفيديو.--}}
{{--                                            </video>--}}
{{--                                        @endif--}}
{{--                                    </div>--}}
{{--                                </div>--}}
                            </div>







                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary btn-sm"> <i class="fa fa-paper-plane"></i>تاكيد</button>

                                <button type="button" class="btn btn-secondary btn-sm" wire:click="closeAddLessonModal">الغاء</button>
                            </div>
                        </form>


                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif

    @if($isEditLessonModalOpen)
        <div class="modal fade show" tabindex="-1" role="dialog" aria-labelledby="modalLabel" style="display: block;" aria-modal="true">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalLabel">تعديل الدرس التعليمي</h5>
                        <button type="button" class="btn-close" wire:click="closeEditLessonModal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form wire:submit.prevent="updateLesson">


                            <div class="form-group mb-3 row">
                                <div class="col-lg-12 col-sm-12">
                                    <label for="name" class="form-label">

                                        الاسم
                                        <span class="required"></span>
                                    </label>
                                    <input type="hidden" id="lessonId" wire:model="lessonId" class="form-control form-control-solid">

                                    <input type="text" id="name" wire:model="edit_lesson_name" class="form-control form-control-solid">
                                    @error('lesson_name')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                </div>


                            </div>

                            <div class="form-group mb-3 row">
                                <div class="col-lg-12 col-sm-12">

                                    <label for="description" class="form-label">

                                        الوصف
                                        <span class="required"></span>
                                    </label>
                                    <textarea  id="description" wire:model="edit_lesson_description" class="form-control form-control-solid"></textarea>
                                    @error('lesson_description')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>



                            <div class="form-group mb-3 row">
                                <div class="col-lg-6 col-sm-12">
                                    <label for="video" class="form-label">إرفاق فيديو</label>
                                    <input type="file" id="video" wire:model="attachment" class="form-control form-control-solid">
                                    @error('attachment')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                    <!-- Display loading state -->
                                    <div wire:loading wire:target="attachment">
                                        <progress max="100" x-bind:value="progress"></progress> <span>Uploading Video...</span>
                                    </div>



                                    <!-- Display video preview only when the upload is complete -->
                                    <div wire:loading.remove wire:target="attachment">
                                        @if ($attachment)
                                            <video width="100%" controls class="m-1" style="width: 150px; height: 150px">
                                                <source src="{{ $attachment->temporaryUrl() }}" type="video/mp4" style="width: 150px; height: 150px">
                                                متصفحك لا يدعم تشغيل الفيديو.
                                            </video>
                                            @elseif ($existingVideoPath)

                                            <video width="100%" controls class="m-1" style="width: 150px; height: 150px">
                                                <source src="{{ asset('storage/' . $existingVideoPath) }}" type="video/mp4">
                                                متصفحك لا يدعم تشغيل الفيديو.
                                            </video>
                                        @endif



                                    </div>
                                </div>

                                <!-- Cover Image Upload -->
                                <div class="col-lg-6 col-sm-12">
                                    <label for="cover_attachment" class="form-label">إرفاق صورة غلاف</label>
                                    <input type="file" id="cover_attachment" wire:model="cover_attachment" class="form-control form-control-solid">

                                    <!-- Display loading state for image -->
                                    <div wire:loading wire:target="cover_attachment">
                                        <progress max="100" x-bind:value="progress"></progress> <span>Uploading Image...</span>
                                    </div>

                                    @error('cover_attachment')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                    <!-- Display image preview only when the upload is complete -->
                                    <div wire:loading.remove wire:target="cover_attachment">
                                        @if ($cover_attachment)
                                            <img src="{{ $cover_attachment->temporaryUrl() }}" alt="Cover Image" class="m-1" style="width: 240px; height: 240px">
                                            @elseif ($existingCoverPath)
                                            <img src="{{  asset('storage/' .$existingCoverPath) }}" alt="Cover Image" class="m-1" style="width: 240px; height: 240px">

                                        @endif
                                    </div>
                                </div>
                            </div>






                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary btn-sm"> <i class="fa fa-paper-plane"></i>تاكيد</button>

                                <button type="button" class="btn btn-secondary btn-sm" wire:click="closeEditLessonModal">الغاء</button>
                            </div>
                        </form>


                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif



    @if($isDeleteConfirmationOpen)
        <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog" aria-labelledby="deleteConfirmLabel" aria-modal="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteConfirmLabel">حذف</h5>
                        <button type="button" class="close" wire:click="closeDeleteConfirmation" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>هل انت متاكد من عملية حذف قصل  المادة التعليمية</p>
                    </div>
                    <div class="modal-footer">
                        <button wire:click="deleteConfirmed" class="btn btn-danger btn-sm">
                            <i class="fa fa-trash"></i> تاكيد
                        </button>
                        <button type="button" class="btn btn-secondary btn-sm" wire:click="closeDeleteConfirmation">الغاء</button>

                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif

    @if($isDeleteLessonConfirmationOpen)
        <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog" aria-labelledby="deleteLessonConfirmLabel" aria-modal="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteLessonConfirmLabel">حذف</h5>
                        <button type="button" class="close" wire:click="closeDeleteLessonConfirmation" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>هل انت متاكد من عملية حذف الدرس </p>
                    </div>
                    <div class="modal-footer">
                        <button wire:click="deleteLessonConfirmed" class="btn btn-danger btn-sm">
                            <i class="fa fa-trash"></i> تاكيد
                        </button>
                        <button type="button" class="btn btn-secondary btn-sm" wire:click="closeDeleteLessonConfirmation">الغاء</button>

                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif
</div>

