
    <div class="container mt-4">
        <!-- Table -->
        <div class="card card-flush">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h3 class="card-title">عرض قائمة الحصص الدراسية</h3>
                <button type="button" class="btn btn-success" wire:click="openModal">
                    <i class="fa fa-plus"></i> اضافة حصة دراسية
                </button>
            </div>

            <div class="card-body">

                <div class="row mb-3">
                    <div class="col-sm-12 col-lg-4 mb-3">
                        <label for="search" class="form-label"></label>
                        <input type="text" wire:model.live.debounce.250ms="search" class="form-control" placeholder="ابحث بالمدرس أو الفصل الدراسي...">
                    </div>

                    <div class="col-sm-12 col-lg-4 mb-3">
                        <label for="teacher_id" class="form-label">القاعة الدراسية</label>
                        <select wire:model.live="lab_id" class="form-select">
                            <option value="">اختر الدراسية</option>
                            @foreach($labs as $teacher)
                                <option value="{{ $teacher->id }}">{{ $teacher->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-sm-12 col-lg-4 mb-3">
                        <label for="class_room_id" class="form-label">المرحلة الدراسية</label>
                        <select wire:model.live="search_class_room_id" class="form-select" wire:change="onSearchClassRoomChange" >
                            <option value="">اختر المرحلة الدراسية</option>
                            @foreach($classRooms as $room)
                                <option value="{{ $room->id }}">{{ $room->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-sm-12 col-lg-4 mb-3">
                        <label for="class_section_id" class="form-label">الفصل الدراسي</label>
                        <select wire:model.live.debounce.250ms="class_section_id" class="form-select">
                            <option value="">اختر الفصل الدراسي</option>
                            @foreach($classSections as $section)
                                <option value="{{ $section->id }}">{{ $section->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-sm-12 col-lg-4 mb-3">
                        <label for="class_section_id" class="form-label">المادة الدراسية</label>
                        <select wire:model.live.debounce.250ms="material_id" class="form-select">
                            <option value="">اختر المادة الدراسي</option>
                            @foreach($materials as $value)
                                <option value="{{ $value->id }}">{{ $value->name }}</option>
                            @endforeach
                        </select>
                    </div>



                    <div class="col-sm-12 col-lg-4 mb-3">
                        <label for="teacher_id" class="form-label">المدرس</label>
                        <select wire:model.live="teacher_id" class="form-select">
                            <option value="">اختر المدرس</option>
                            @foreach($teachers as $teacher)
                                <option value="{{ $teacher->id }}">{{ $teacher->name }}</option>
                            @endforeach
                        </select>
                    </div>


                    <div class="col-sm-12 col-lg-4">
                        <label for="date" class="form-label">التاريخ</label>
                        <div wire:ignore>
                            <input
                                x-data
                                x-init="flatpickr($refs.input, {
            'enableTime': false,
            'dateFormat': 'Y-m-d'
        });"
                                x-ref="input"
                                type="text"
                                data-input
                                id="date-picker"
                                placeholder="Select date..."
                                required
                                class="form-control"
                                wire:model.live="date"
                            />
                        </div>
                    </div>

                </div>

                <table class="table align-middle table-row-dashed fs-6 gy-5">
                    <thead>
                    <tr>
                        <th>القاعة الدراسية</th>
                        <th>الصف الدراسي</th>
                        <th>المادة الدراسية</th>
                        <th>المدرس</th>
                        <th>الشعبة</th>
                        <th>اليوم</th>
                        <th>من وقت</th>
                        <th>الى وقت </th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($classPeriods as $value)
                        <tr>
                            <td>{{ $value->labs?->name }}</td>
                            <td>{{ $value->classRooms?->name }}</td>

                            <td>{{ $value->materials?->name }}</td>
                            <td>{{ $value->teachers?->name }}</td>
                            <td>{{ $value->classSections?->name }}</td>

                            <td>{{ $value->date }}</td>
                            <td>{{ $value->start_time }}</td>
                            <td>{{ $value->end_time }}</td>

                            <td>
                                <button wire:click="openModal({{ $value->id }})" class="btn btn-primary btn-sm">
                                    <i class="fa fa-edit"></i> تعديل
                                </button>
                                <button wire:click="confirmDelete({{ $value->id }})" class="btn btn-danger btn-sm">
                                    <i class="fa fa-trash"></i> حذف
                                </button>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>

                <!-- Pagination Links -->
                <div class="mt-4">
                    {{ $classPeriods->links('vendor.livewire.bootstrap') }}
                </div>
            </div>
        </div>

        <!-- Modal for Edit/Create Grade -->
        @if($isModalOpen)
            <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
                <div class="modal-dialog modal-xl" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">{{ $classPeriodId ? 'تعديل بيانات الحصة الدراسية' : 'اضافة حصة دراسية' }}</h5>
                            <button type="button" class="btn-close" wire:click="closeModal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form wire:submit.prevent="save">
                                @if ($errors->any())
                                    <div class="alert alert-danger">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif

                                <div class="row">
                                    <div class="col-sm-12 col-lg-4 mb-3">
                                        <label for="lab_id" class="form-label">القاعات الدرسية</label>
                                        <select wire:model="lab_id" class="form-select"  >
                                            <option value="">اختر القاعة الدارسية</option>
                                            @foreach($labs as $value)
                                                <option value="{{ $value->id }}">{{ $value->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-sm-12 col-lg-4 mb-3">
                                        <label for="class_room_id" class="form-label">المرحلة الدراسية</label>
                                        <select wire:model="class_room_id" class="form-select" wire:change="onClassRoomChange" >
                                            <option value="">اختر المرحلة الدراسية</option>
                                            @foreach($classRooms as $room)
                                                <option value="{{ $room->id }}">{{ $room->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-sm-12 col-lg-4 mb-3">
                                        <label for="class_section_id" class="form-label">الشعبة الدراسية</label>
                                        <select wire:model="class_section_id"  class="form-select" id="class_section_id" >
                                            <option value="">اختر الشعبة</option>
                                            @foreach($classSections as $value)
                                                <option value="{{ $value->id }}"@if($value->id ==$class_section_id)selected @endif> {{ $value->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>



                                </div>





                                <div class="row mb-3">
                                    <div class="col-sm-12 col-lg-4">
                                        <label for="material_id" class="form-label">المادة الدراسية</label>
                                        <select wire:model="material_id"  class="form-select" id="material_id"  >
                                            <option value="">اختر المادة الدراسية</option>
                                            @foreach($materials as $value)
                                                <option value="{{ $value->id }}"@if($value->id ==$material_id)selected @endif> {{ $value->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-sm-12 col-lg-4">
                                        <label for="teacher_id" class="form-label">المدرس</label>
                                        <select wire:model="teacher_id" class="form-select">
                                            <option value="">اختر المدرس</option>
                                            @foreach($teachers as $teacher)
                                                <option value="{{ $teacher->id }}">{{ $teacher->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-sm-12 col-lg-4">
                                        <label for="date" class="form-label">اليوم</label>
                                        <div wire:ignore>
                                            <input
                                                x-data
                                                x-init="flatpickr($refs.input, {
            'enableTime': false,
            'dateFormat': 'Y-m-d'
        });"
                                                x-ref="input"
                                                type="text"
                                                data-input
                                                id="date-picker"
                                                placeholder="Select date..."
                                                required
                                                class="form-control"
                                                wire:model="date"
                                            />
                                        </div>
                                    </div>


                                </div>
                                    <div class="row mb-3">

                                    <div class="col-sm-12 col-lg-4">
                                        <label for="start_time" class="form-label">الوقت البداية</label>
                                        <div wire:ignore>
                                            <input
                                                x-data
                                                x-init="flatpickr($refs.input, {'enableTime': true, 'noCalendar': true, 'dateFormat': 'H:i', 'time_24hr': true, 'defaultHour': 12, 'minuteIncrement': 1});"
                                                x-ref="input"
                                                type="text"
                                                data-input
                                                id="start-time-picker"
                                                placeholder="Select time..."
                                                required
                                                class="form-control"
                                                wire:model="start_time"
                                            />
                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-lg-4">
                                        <label for="end_time" class="form-label">الوقت النهاية</label>
                                        <div wire:ignore>
                                            <input
                                                x-data
                                                x-init="flatpickr($refs.input, {'enableTime': true, 'noCalendar': true, 'dateFormat': 'H:i', 'time_24hr': true, 'defaultHour': 12, 'minuteIncrement': 1});"
                                                x-ref="input"
                                                type="text"
                                                data-input
                                                id="end-time-picker"
                                                placeholder="Select time..."
                                                required
                                                class="form-control"
                                                wire:model="end_time"

                                            />
                                        </div>
                                    </div>
                                    </div>



                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" wire:click="closeModal">اغلاق</button>
                                    <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">حفظ</button>
                                    <span wire:loading>Saving...</span>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>

    <!-- Delete Confirmation Modal -->
    @if($isDeleteConfirmationOpen)
        <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog" aria-labelledby="deleteConfirmLabel" aria-modal="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteConfirmLabel">حذف</h5>
                        <button type="button" class="close" wire:click="closeDeleteConfirmation" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>هل انت متاكد من عملية حذف الحصة الدراسية</p>
                    </div>
                    <div class="modal-footer">
                        <button wire:click="deleteConfirmed" class="btn btn-danger btn-sm">
                            <i class="fa fa-trash"></i> تاكيد
                        </button>
                        <button type="button" class="btn btn-secondary btn-sm" wire:click="closeDeleteConfirmation">الغاء</button>

                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
@endif


